% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{calculate_mcc}
\alias{calculate_mcc}
\title{Calculate Matthews correlation coefficient vector}
\usage{
calculate_mcc(tp, tn, fp, fn)
}
\arguments{
\item{tp}{numeric vector of TPs}

\item{tn}{numeric vector of TNs}

\item{fp}{numeric vector of FPs}

\item{fn}{numeric vector of FNs}
}
\value{
a numeric vector of MCC values, each value being in the [-1,1]
interval. If any of the four sums of the MCC formula are zero, then we return
an MCC score of zero, which can be shown to be the correct limiting value (model
is no better than a random predictor, see
\href{https://doi.org/10.1186/s12864-019-6413-7}{Chicco et al. (2020)}).
}
\description{
Use this function to calculate the MCC scores given vectors of \emph{TP} (true
positives), \emph{FP} (false positives), \emph{TN} (true negatives) and \emph{FN}
(false negatives) values.
Note that the input vectors have to be of the same size and have one-to-one value
correspondence for the output MCC vector to make sense.
}
\seealso{
Other confusion matrix calculation functions: 
\code{\link{calculate_models_mcc}()},
\code{\link{calculate_models_synergies_fn}()},
\code{\link{calculate_models_synergies_fp}()},
\code{\link{calculate_models_synergies_tn}()},
\code{\link{calculate_models_synergies_tp}()}
}
\concept{confusion matrix calculation functions}
