% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_activity_diff_mat_based_on_tp_predictions}
\alias{get_avg_activity_diff_mat_based_on_tp_predictions}
\title{Get average activity difference matrix based on the number of true positives}
\usage{
get_avg_activity_diff_mat_based_on_tp_predictions(models,
  models.synergies.tp, models.stable.state)
}
\arguments{
\item{models}{character vector. The model names.}

\item{models.synergies.tp}{an integer vector of TP values. The \emph{names}
attribute holds the models' names and have to be in the same order as in the
\code{models} parameter.}

\item{models.stable.state}{a matrix (nxm) with n models and m nodes. The row
names of the matrix specify the models' names (same order as in the \code{models}
parameter) whereas the column names specify the name of the network nodes
(gene, proteins, etc.). Possible values for each \emph{model-node element}
are either \emph{0} (inactive node) or \emph{1} (active node).}
}
\value{
a matrix whose rows are \strong{vectors of
average node activity state differences} between two groups of models where
the classification was based on the number of true positive predictions.
Rows represent the different classification group matchings, e.g. (1,2) means the
models that predicted 1 TP synergy vs the models that predicted 2 TP
synergies and the columns represent the network's node names.
Values are in the [-1,1] interval.
}
\description{
This function finds all the TP values of the models given (e.g. 0,1,2,3),
generates every pairwise combination (e.g. the group matchings: (0,1), (1,3),
etc.) and uses the \code{\link{get_avg_activity_diff_based_on_tp_predictions}}
function on each generated classification group matching, comparing thus all
groups of models with different true positive (TP) values.
}
\seealso{
Other average data difference functions: \code{\link{get_avg_activity_diff_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}},
  \code{\link{get_avg_activity_diff_based_on_tp_predictions}},
  \code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}}
}
\concept{average data difference functions}
