% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.glm.R
\name{em.glm}
\alias{em.glm}
\title{Expectation Maximization glm.}
\usage{
em.glm(x, y, b.init = "random,", weight = c(1), K = 2,
  family = poisson, method = "numeric", maxiter = 50,
  maxiter.NR = Inf, tol.1 = 1e-08, tol.2 = 1e-08, noise = 0.2,
  debug = FALSE, param_errors = FALSE)
}
\arguments{
\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{b.init}{The method to initialize EM parameters.  Built in methods are "random" and "fit" for pure white noise, and white noise around GLM estimates.  Alternatively, pass a list of length K, each element consisting of a vector of length \emph{p}.  Users can also pass a zero-argument function to produce starting states.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{K}{Number of EM classes to be fit.}

\item{family}{GLM family to fit.}

\item{method}{Control string.  Set to 'numeric' or 'pracma'.}

\item{maxiter}{Maximum number of re-weighting rounds to do in fitting the EM model.  Primarily used to perform the 'small.em' warm-up routine.}

\item{maxiter.NR}{Maximum number of Newton-Raphson steps to take.}

\item{tol.1}{Escape tolerance of the Newton-Raphson step.}

\item{tol.2}{Escape tolerance of the re-weighting step.}

\item{noise}{Standard deviation of the white noise to be applied when generating random initial states.}

\item{debug}{Returns step-size in NR and re-weighting steps as a message if TRUE.}

\item{param_errors}{Bool flag - set to TRUE to calculate parameter errors.}
}
\value{
An 'em.glm' object containing the class parameters, and class weights.
}
\description{
Fit an Expectation Maximization glm using the glm \emph{family} to define the link function.  Two methods of optimization are included,
using direct numeric approximations and using the \emph{pracma} package to find the Hessian and Jacobian of the log-likelihood.  The number of
competing models to be fit is set by \emph{K}.
}
\details{
It is recommend users first call the \strong{em.small} command to run small warm up trails to explore the parameter space.
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks
m <- em.glm(x = x, y = y, K = 2, b.init = "random")
summary(m)

}
\references{
{
\href{https://www.jstatsoft.org/v027/i08}{Zeileis et al (2008)} Regression Models for Count Data in R <doi:10.18637/jss.v027.i08>

\href{https://web.stanford.edu/~hastie/Papers/ESLII.pdf}{Hastie et al (2009)} The Elements of Statistical Learning Chapter 8.5 The EM Algorithm (2nd edition)  <doi:10.1007/978-0-387-21606-5_7>

\href{http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.28.613}{Jeff Bilmes (1998)} A Gentle Tutorial of the EM Algorithm and its Application to Parameter Estimation for Gaussian Mixture and Hidden Markov Models}

\href{http://www.jstor.org/stable/2984875}{Dempster et al (1977)} Maximum Likelihood from Incomplete Data via the EM Algorithm
}
