% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.run.helpers.R
\name{elo.run.helpers}
\alias{elo.run.helpers}
\alias{as.matrix.elo.run}
\alias{as.matrix.elo.run.regressed}
\alias{as.data.frame.elo.run}
\alias{final.elos}
\alias{final.elos.elo.run}
\alias{final.elos.elo.run.regressed}
\title{Helper functions for \code{elo.run}}
\usage{
\method{as.matrix}{elo.run}(x, ...)

\method{as.matrix}{elo.run.regressed}(x, ...)

\method{as.data.frame}{elo.run}(x, ...)

final.elos(x, ...)

\method{final.elos}{elo.run}(x, ...)

\method{final.elos}{elo.run.regressed}(x, regressed = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{"elo.run"} or class \code{"elo.run.regressed"}.}

\item{...}{Other arguments (Not in use at this time).}

\item{regressed}{Logical, denoting whether to use the post-regressed (\code{TRUE}) or
pre-regressed (\code{FALSE}) final Elos. Note that \code{TRUE} only makes sense when the
final Elos were regressed one last time (i.e., if the last element of the \code{regress()})
vector yields \code{TRUE}).}
}
\value{
A matrix, a data.frame, or a named vector.
}
\description{
\code{as.matrix} converts an Elo object into a matrix of running Elos. These are the Elos at the time of grouping,
  but before any regression takes place.
}
\details{
\code{as.data.frame} converts the \code{"elos"} component of an object
  from \code{\link{elo.run}} into a data.frame.

\code{final.elos} is a generic function to extract the last Elo per team.
}
\examples{
e <- elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor + group(week),
             data = tournament, k = 20)
head(as.matrix(e))
str(as.data.frame(e))
final.elos(e)
}
\seealso{
\code{\link{elo.run}}
}
