% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{type_boolean}
\alias{type_boolean}
\alias{type_integer}
\alias{type_number}
\alias{type_string}
\alias{type_enum}
\alias{type_array}
\alias{type_object}
\alias{type_from_schema}
\title{Type specifications}
\usage{
type_boolean(description = NULL, required = TRUE)

type_integer(description = NULL, required = TRUE)

type_number(description = NULL, required = TRUE)

type_string(description = NULL, required = TRUE)

type_enum(values, description = NULL, required = TRUE)

type_array(items, description = NULL, required = TRUE)

type_object(
  .description = NULL,
  ...,
  .required = TRUE,
  .additional_properties = FALSE
)

type_from_schema(text, path)
}
\arguments{
\item{description, .description}{The purpose of the component. This is
used by the LLM to determine what values to pass to the tool or what
values to extract in the structured data, so the more detail that you can
provide here, the better.}

\item{required, .required}{Is the component or argument required?

In type descriptions for structured data, if \code{required = FALSE} and the
component does not exist in the data, the LLM may hallucinate a value. Only
applies when the element is nested inside of a \code{type_object()}.

In tool definitions, \code{required = TRUE} signals that the LLM should always
provide a value. Arguments with \code{required = FALSE} should have a default
value in the tool function's definition. If the LLM does not provide a
value, the default value will be used.}

\item{values}{Character vector of permitted values.}

\item{items}{The type of the array items. Can be created by any of the
\code{type_} function.}

\item{...}{Name-type pairs defineing the components that the object must
possess.}

\item{.additional_properties}{Can the object have arbitrary additional
properties that are not explicitly listed? Only supported by Claude.}

\item{text}{A JSON string.}

\item{path}{A file path to a JSON file.}
}
\description{
These functions specify object types in a way that chatbots understand and
are used for tool calling and structured data extraction. Their names are
based on the \href{https://json-schema.org}{JSON schema}, which is what the APIs
expect behind the scenes. The translation from R concepts to these types is
fairly straightforward.
\itemize{
\item \code{type_boolean()}, \code{type_integer()}, \code{type_number()}, and \code{type_string()}
each represent scalars. These are equivalent to length-1 logical,
integer, double, and character vectors (respectively).
\item \code{type_enum()} is equivalent to a length-1 factor; it is a string that can
only take the specified values.
\item \code{type_array()} is equivalent to a vector in R. You can use it to represent
an atomic vector: e.g. \code{type_array(type_boolean())} is equivalent
to a logical vector and \code{type_array(type_string())} is equivalent
to a character vector). You can also use it to represent a list of more
complicated types where every element is the same type (R has no base
equivalent to this), e.g. \code{type_array(type_array(type_string()))}
represents a list of character vectors.
\item \code{type_object()} is equivalent to a named list in R, but where every element
must have the specified type. For example,
\code{type_object(a = type_string(), b = type_array(type_integer()))} is
equivalent to a list with an element called \code{a} that is a string and
an element called \code{b} that is an integer vector.
\item \code{type_from_schema()} allows you to specify the full schema that you want to
get back from the LLM as a JSON schema. This is useful if you have a
pre-defined schema that you want to use directly without manually creating
the type using the \verb{type_*()} functions. You can point to a file with the
\code{path} argument or provide a JSON string with \code{text}. The schema must be a
valid JSON schema object.
}
}
\examples{
# An integer vector
type_array(type_integer())

# The closest equivalent to a data frame is an array of objects
type_array(type_object(
   x = type_boolean(),
   y = type_string(),
   z = type_number()
))

# There's no specific type for dates, but you use a string with the
# requested format in the description (it's not gauranteed that you'll
# get this format back, but you should most of the time)
type_string("The creation date, in YYYY-MM-DD format.")
type_string("The update date, in dd/mm/yyyy format.")
}
