% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{index}
\alias{index}
\alias{index_analyze}
\alias{index_clear_cache}
\alias{index_close}
\alias{index_create}
\alias{index_delete}
\alias{index_exists}
\alias{index_flush}
\alias{index_get}
\alias{index_open}
\alias{index_optimize}
\alias{index_recovery}
\alias{index_recreate}
\alias{index_segments}
\alias{index_settings}
\alias{index_settings_update}
\alias{index_stats}
\alias{index_upgrade}
\title{Index API operations}
\usage{
index_get(index = NULL, features = NULL, raw = FALSE, verbose = TRUE,
  ...)

index_exists(index, ...)

index_delete(index, raw = FALSE, verbose = TRUE, ...)

index_create(index = NULL, body = NULL, raw = FALSE, verbose = TRUE,
  ...)

index_recreate(index = NULL, body = NULL, raw = FALSE, verbose = TRUE,
  ...)

index_close(index, ...)

index_open(index, ...)

index_stats(index = NULL, metric = NULL, completion_fields = NULL,
  fielddata_fields = NULL, fields = NULL, groups = NULL,
  level = "indices", ...)

index_settings(index = "_all", ...)

index_settings_update(index = NULL, body, ...)

index_segments(index = NULL, ...)

index_recovery(index = NULL, detailed = FALSE, active_only = FALSE, ...)

index_optimize(index = NULL, max_num_segments = NULL,
  only_expunge_deletes = FALSE, flush = TRUE, wait_for_merge = TRUE, ...)

index_upgrade(index = NULL, wait_for_completion = FALSE, ...)

index_analyze(text = NULL, field = NULL, index = NULL, analyzer = NULL,
  tokenizer = NULL, filters = NULL, char_filters = NULL, body = list(),
  ...)

index_flush(index = NULL, force = FALSE, full = FALSE,
  wait_if_ongoing = FALSE, ...)

index_clear_cache(index = NULL, filter = FALSE, filter_keys = NULL,
  fielddata = FALSE, query_cache = FALSE, id_cache = FALSE, ...)
}
\arguments{
\item{index}{(character) A character vector of index names}

\item{features}{(character) A character vector of features. One or more of settings, mappings,
warmers or aliases}

\item{raw}{If TRUE (default), data is parsed to list. If FALSE, then raw JSON.}

\item{verbose}{If TRUE (default) the url call used printed to console.}

\item{...}{Curl args passed on to \code{\link[httr]{POST}}, \code{\link[httr]{GET}},
\code{\link[httr]{PUT}}, \code{\link[httr]{HEAD}}, or \code{\link[httr]{DELETE}}}

\item{body}{Query, either a list or json.}

\item{metric}{(character) A character vector of metrics to display. Possible values: "_all",
"completion", "docs", "fielddata", "filter_cache", "flush", "get", "id_cache", "indexing",
"merge", "percolate", "refresh", "search", "segments", "store", "warmer".}

\item{completion_fields}{(character) A character vector of fields for completion metric
(supports wildcards)}

\item{fielddata_fields}{(character) A character vector of fields for fielddata metric
(supports wildcards)}

\item{fields}{(character) Fields to add.}

\item{groups}{(character) A character vector of search groups for search statistics.}

\item{level}{(character) Return stats aggregated on "cluster", "indices" (default) or "shards"}

\item{detailed}{(logical) Whether to display detailed information about shard recovery.
Default: FALSE}

\item{active_only}{(logical) Display only those recoveries that are currently on-going.
Default: FALSE}

\item{max_num_segments}{(character) The number of segments the index should be merged into.
Default: "dynamic"}

\item{only_expunge_deletes}{(logical) Specify whether the operation should only expunge
deleted documents}

\item{flush}{(logical) Specify whether the index should be flushed after performing the
operation. Default: TRUE}

\item{wait_for_merge}{(logical) Specify whether the request should block until the merge
process is finished. Default: TRUE}

\item{wait_for_completion}{(logical) Should the request wait for the upgrade to complete.
Default: FALSE}

\item{text}{The text on which the analysis should be performed (when request body is not used)}

\item{field}{Use the analyzer configured for this field (instead of passing the analyzer name)}

\item{analyzer}{The name of the analyzer to use}

\item{tokenizer}{The name of the tokenizer to use for the analysis}

\item{filters}{A character vector of filters to use for the analysis}

\item{char_filters}{A character vector of character filters to use for the analysis}

\item{force}{(logical) Whether a flush should be forced even if it is not necessarily needed
ie. if no changes will be committed to the index.}

\item{full}{(logical) If set to TRUE a new index writer is created and settings that have been
changed related to the index writer will be refreshed.}

\item{wait_if_ongoing}{If TRUE, the flush operation will block until the flush can be executed
if another flush operation is already executing. The default is false and will cause an
exception to be thrown on the shard level if another flush operation is already running.
[1.4.0.Beta1]}

\item{filter}{(logical) Clear filter caches}

\item{filter_keys}{(character) A vector of keys to clear when using the \code{filter_cache}
parameter (default: all)}

\item{fielddata}{(logical) Clear field data}

\item{query_cache}{(logical) Clear query caches}

\item{id_cache}{(logical) Clear ID caches for parent/child}
}
\description{
Index API operations
}
\details{
\bold{index_analyze}:
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-analyze.html}
This method can accept a string of text in the body, but this function passes it as a
parameter in a GET request to simplify.

\bold{index_flush}:
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-flush.html}
From the ES website: The flush process of an index basically frees memory from the index by
flushing data to the index storage and clearing the internal transaction log. By default,
Elasticsearch uses memory heuristics in order to automatically trigger flush operations as
required in order to clear memory.

\bold{index_status}: The API endpoint for this function was deprecated in
Elasticsearch \code{v1.2.0}, and will likely be removed soon. Use \code{\link{index_recovery}}
instead.

\bold{index_settings_update}: There are a lot of options you can change with this
function. See
https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-update-settings.html
for all the options.
}
\examples{
\dontrun{
# get information on an index
index_get(index='shakespeare')
index_get(index='shakespeare', features=c('settings','mappings'))
index_get(index='shakespeare', features='aliases')
index_get(index='shakespeare', features='warmers')

# check for index existence
index_exists(index='shakespeare')
index_exists(index='plos')

# create an index
if (index_exists('twitter')) index_delete('twitter')
index_create(index='twitter')
if (index_exists('things')) index_delete('things')
index_create(index='things')
if (index_exists('plos')) index_delete('plos')
index_create(index='plos')

# re-create an index
index_recreate("deer")
index_recreate("deer", verbose = FALSE)

# delete an index
if (index_exists('plos')) index_delete(index='plos')

## with a body
body <- '{
 "settings" : {
  "index" : {
    "number_of_shards" : 3,
    "number_of_replicas" : 2
   }
 }
}'
if (index_exists('alsothat')) index_delete('alsothat')
index_create(index='alsothat', body=body)

## with mappings
body <- '{
 "mappings": {
   "record": {
     "properties": {
       "location" : {"type" : "geo_point"}
      }
   }
 }
}'
if (!index_exists('gbifnewgeo')) index_create(index='gbifnewgeo', body=body)
gbifgeo <- system.file("examples", "gbif_geosmall.json", package = "elastic")
docs_bulk(gbifgeo)

# close an index
index_create('plos')
index_close('plos')

# open an index
index_open('plos')

# Get stats on an index
index_stats('plos')
index_stats(c('plos','gbif'))
index_stats(c('plos','gbif'), metric='refresh')
index_stats(metric = "indices")
index_stats('shakespeare', metric='completion')
index_stats('shakespeare', metric='completion', completion_fields = "completion")
index_stats('shakespeare', metric='fielddata')
index_stats('shakespeare', metric='fielddata', fielddata_fields = "evictions")
index_stats('plos', level="indices")
index_stats('plos', level="cluster")
index_stats('plos', level="shards")

# Get segments information that a Lucene index (shard level) is built with
index_segments()
index_segments('plos')
index_segments(c('plos','gbif'))

# Get recovery information that provides insight into on-going index shard recoveries
index_recovery()
index_recovery('plos')
index_recovery(c('plos','gbif'))
index_recovery("plos", detailed = TRUE)
index_recovery("plos", active_only = TRUE)

# Optimize an index, or many indices
index_optimize('plos')
index_optimize(c('plos','gbif'))

# Upgrade one or more indices to the latest format. The upgrade process converts any
# segments written with previous formats.
index_upgrade('plos')
index_upgrade(c('plos','gbif'))

# Performs the analysis process on a text and return the tokens breakdown of the text.
index_analyze(text = 'this is a test', analyzer='standard')
index_analyze(text = 'this is a test', analyzer='whitespace')
index_analyze(text = 'this is a test', analyzer='stop')
index_analyze(text = 'this is a test', tokenizer='keyword', filters='lowercase')
index_analyze(text = 'this is a test', tokenizer='keyword', filters='lowercase',
   char_filters='html_strip')
index_analyze(text = 'this is a test', index = 'plos')
index_analyze(text = 'this is a test', index = 'shakespeare')
index_analyze(text = 'this is a test', index = 'shakespeare', config=verbose())

## NGram tokenizer
body <- '{
        "settings" : {
             "analysis" : {
                 "analyzer" : {
                     "my_ngram_analyzer" : {
                         "tokenizer" : "my_ngram_tokenizer"
                     }
                 },
                 "tokenizer" : {
                     "my_ngram_tokenizer" : {
                         "type" : "nGram",
                         "min_gram" : "2",
                         "max_gram" : "3",
                         "token_chars": [ "letter", "digit" ]
                     }
                 }
             }
      }
}'
if(index_exists("shakespeare2")) {
   index_delete("shakespeare2")
}
tokenizer_set(index = "shakespeare2", body=body)
index_analyze(text = "art thouh", index = "shakespeare2", analyzer='my_ngram_analyzer')

# Explicitly flush one or more indices.
index_flush(index = "plos")
index_flush(index = "shakespeare")
index_flush(index = c("plos","shakespeare"))
index_flush(index = "plos", wait_if_ongoing = TRUE)
library('httr')
index_flush(index = "plos", config=verbose())

# Clear either all caches or specific cached associated with one ore more indices.
index_clear_cache()
index_clear_cache(index = "plos")
index_clear_cache(index = "shakespeare")
index_clear_cache(index = c("plos","shakespeare"))
index_clear_cache(filter = TRUE)
library('httr')
index_clear_cache(config=verbose())

# Index settings
## get settings
index_settings()
index_settings("_all")
index_settings('gbif')
index_settings(c('gbif','plos'))
index_settings('*s')
## update settings
if (index_exists('foobar')) index_delete('foobar')
index_create("foobar")
settings <- list(index = list(number_of_replicas = 4))
index_settings_update("foobar", body = settings)
index_get("foobar")$foobar$settings
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices.html}
}

