% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_delete.R
\name{docs_delete}
\alias{docs_delete}
\title{Delete a document.}
\usage{
docs_delete(index, type, id, refresh = NULL, routing = NULL,
  timeout = NULL, version = NULL, version_type = NULL,
  callopts = list(), ...)
}
\arguments{
\item{index}{(character) The name of the index. Required}

\item{type}{(character) The type of the document. Required}

\item{id}{(numeric/character) The document ID. Can be numeric or character. Required}

\item{refresh}{(logical) Refresh the index after performing the operation}

\item{routing}{(character) Specific routing value}

\item{timeout}{(character) Explicit operation timeout, e.g,. 5m (for 5 minutes)}

\item{version}{(character) Explicit version number for concurrency control}

\item{version_type}{(character) Specific version type. One of internal or external}

\item{callopts}{Curl args passed on to \code{\link[httr]{DELETE}}}

\item{...}{Further args to query DSL}
}
\description{
Delete a document.
}
\examples{
\dontrun{
if (!index_exists("plos")) {
 plosdat <- system.file("examples", "plos_data.json", package = "elastic")
 docs_bulk(plosdat)
}

# delete a document
docs_get(index='plos', type='article', id=36)
docs_delete(index='plos', type='article', id=36)
# docs_get(index='plos', type='article', id=36) # and the document is gone
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-delete.html}
}

