% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mean.R
\name{fit_mean}
\alias{fit_mean}
\title{Mean estimation for open planar curves.}
\usage{
fit_mean(
  srv_data_curves,
  knots,
  penalty,
  var_type,
  pfit_method,
  max_iter,
  type,
  eps,
  cluster,
  verbose,
  smooth_warp
)
}
\arguments{
\item{srv_data_curves}{list of \code{data.frame}s with srv vectors in each row.curves}

\item{knots}{set of knots for the mean spline curve}

\item{penalty}{the penalty to use in the covariance smoothing step. use '-1' for no penalty.}

\item{var_type}{(experimental) assume "smooth", "constant" or "zero" measurement-error variance along t}

\item{pfit_method}{(experimental) "smooth" or "polygon"}

\item{max_iter}{maximal number of iterations}

\item{type}{if "smooth" linear srv-splines are used which results in a differentiable mean curve
if "polygon" the mean will be piecewise linear.}

\item{eps}{the algorithm stops if L2 norm of coefficients changes less}

\item{cluster}{a cluster object for use in the \code{bam} call}

\item{verbose}{print iterations}

\item{smooth_warp}{(experimental) controls the weighting of original and smoothed observations
over the iterations, if pfit_method == "smooth".}
}
\value{
a \code{list} with entries
\item{type}{"smooth" or "polygon"}
\item{coefs}{\code{coefs} srv spline coefficients of the estimated mean}
\item{knots}{spline knots}
\item{penalty}{penalty used in the covariance estimation}
\item{distances}{distances to mean}
\item{fit}{a \code{list} containing
\code{t_optims}{optimal parametrizations}
\code{G_optims}{optimal rotations}
\code{b_optims}{optimal scalings}
\code{n_optims}{optimal re-normalization}
\code{n_iter}{number of iterations until convergence}
\code{gram} the mean basis Gram matrix,
\code{cov_fit} the covariance smoothing objects in the final iteration,
\code{cov_pca} cov coef matrix pca object in the final iteration and
\code{pfit_coefs} the mean basis coefs of smoothed pfits in the final iteration}
}
\description{
Fits an elastic full Procrustes mean for open, planar curves.
Is usually called from \code{\link{compute_elastic_shape_mean}}.
}
