% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eicm-options.r
\name{eicm.data}
\alias{eicm.data}
\title{Define a data object for a EICM model}
\usage{
eicm.data(occurrences = NULL, env = NULL, traits = NULL, intercept = TRUE)
}
\arguments{
\item{occurrences}{a binary (0/1) sample x species matrix, possibly including NAs.}

\item{env}{an optional sample x environmental variable matrix, for the known environmental predictors.}

\item{traits}{an optional species x trait matrix. Currently, it is only used for excluding
species interactions \emph{a priori}.}

\item{intercept}{logical specifying whether to add a column for the species-level intercepts.}
}
\value{
A \code{eicm.data} object that can be used for defining a model.
}
\description{
Constructs a EICM data object for prediction. The data object contains all data matrices that may be needed for prediction.
Usually, you don't need to invoke this function directly, use \code{\link{as.eicm}} instead.
}
