% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.eicm}
\alias{plot.eicm}
\title{Quick plot EICM results}
\usage{
\method{plot}{eicm}(x, type = ifelse(is.null(true.model), "network",
  "coefficients"), true.model = NULL, ...)
}
\arguments{
\item{x}{a EICM model.}

\item{type}{character. The type of plot, one of \code{confint}, \code{profile}, \code{network} or \code{coefficients}.
See details.}

\item{true.model}{the true model to compare with (usually, the one used for simulating the data).}

\item{...}{further arguments to pass to \code{\link{coefficientComparisonPlot}} or other plotting functions.}
}
\value{
NULL.
}
\description{
Multiple types of plots for EICM models: coefficients, network topology, confidence intervals and likelihood profiles.
Allows to plot a single model or the comparison between an estimated and a true model.
}
\details{
If no \code{true.model} is provided, \code{type} must be one of \code{confint}, \code{profile}, \code{network}.

If \code{true.model} is provided, \code{type} must be one of \code{network} or \code{coefficients}.
In the latter case, see \code{\link{coefficientComparisonPlot}} for possible options.

If \code{x} is of type \code{eicm.list} (as returned by \code{\link{eicm}}), this function first
tries to plot the model after network selection, then, if it was not computed, the fitted model with the full network.
}
\seealso{
\code{\link{coefficientComparisonPlot}}, \code{\link{confint.eicm}}
}
