% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eglm.R
\name{eglm}
\alias{eglm}
\title{Efficient Fitting of Generalized Linear Models}
\usage{
eglm(
  formula,
  family = gaussian,
  data,
  weights,
  subset,
  na.action,
  start = NULL,
  etastart,
  mustart,
  offset,
  control = list(...),
  model = TRUE,
  method = "eglm.wfit",
  x = FALSE,
  y = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  reduce = FALSE,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{"\link{formula}"} (or one that can be
coerced to that class): a symbolic description of the model to be fitted.
The details of model specification are given under \sQuote{Details}.}

\item{family}{a description of the error distribution and link function to be
used in the model. This can be a character string naming a
family function, a family function or the result of a call to a family
function. See \code{\link{family}} for details of family functions.}

\item{data}{an optional data frame, list or environment (or object coercible
by \code{\link{as.data.frame}} to a data frame) containing the variables in
the model. If not found in \code{data}, the variables are taken from
\code{environment(formula)}, typically the environment from which \code{lm}
is called.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Should be \code{NULL} or a numeric vector. If non-NULL, weighted
least squares is used with weights \code{weights} (that is, minimizing
\code{sum(w*e^2)}); otherwise ordinary least squares is used.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{\link{options}}, and is \code{\link{na.fail}} if that is unset. The
\sQuote{factory-fresh} default is \code{\link{na.omit}}. Another possible
value is \code{NULL}, no action. Value \code{\link{na.exclude}} can be
useful.}

\item{start}{starting values for the parameters in the linear predictor.}

\item{etastart}{starting values for the linear predictor.}

\item{mustart}{starting values for the vector of means.}

\item{offset}{this can be used to specify an \emph{a priori} known component
to be included in the linear predictor during fitting. This should be
\code{NULL} or a numeric vector or matrix of extents matching those of the
response. One or more \code{\link{offset}} terms can be included in the
formula instead or as well, and if more than one are specified their sum is
used. See \code{\link{model.offset}}.}

\item{control}{a list of parameters for controlling the fitting process. For
\code{eglm.wfit} this is passed to \code{glm.control}.}

\item{model}{a logical value indicating whether \emph{model frame} should be
included as a component of the returned value.}

\item{method}{the method to be used in fitting the model. The default method
\code{"eglm.wfit"} uses iteratively reweighted least squares (IWLS): the
alternative \code{"model.frame"} returns the model frame and does no
fitting. User-supplied fitting functions can be supplied either as a
function or a character string naming a function, with a function which
takes the same arguments as \code{glm.fit} from the \bold{stats} package.
If specified as a character string it is looked up from within the
\bold{eflm} namespace.}

\item{x, y}{logical values indicating whether the
\emph{model matrix} (\code{x}) and the \emph{response vector} (\code{y})
used in the fitting process should be returned as components of the returned
value.}

\item{singular.ok}{logical; if FALSE a singular fit is an error.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of
\code{model.matrix.default}.}

\item{reduce}{logical; if TRUE an alternate design matrix of \code{p * p} is
used for the fitting instead of the traditional \code{n * p} design matrix.}

\item{\dots}{For eglm: arguments to be used to form the default control
argument if it is not supplied directly. For weights: further arguments
passed to or from other methods.}
}
\value{
An object of class "eglm" that behaves the same way as the "glm"
class, see the function \code{"\link{glm}"}. This output also includes the
logical "reduce" and, depending on it, the reduced design matrix "xtx"
when the reduce argument is set to TRUE.
}
\description{
Efficient Generalized Linear Model (\code{"eglm"}) is used to fit generalized
linear models in an equivalent way to \code{"\link{glm}"} but in a reduced
time depending on the design matrix and the family (or link).
}
\details{
Models for \code{eglm} are specified symbolically.
A typical model has the form \code{response ~ terms} where \code{response}
is the (numeric) response vector and \code{terms} is a series of terms which
specifies a linear predictor for \code{response}. A terms specification of
the form \code{first + second} indicates all the terms in \code{first}
together with all the terms in \code{second} with duplicates removed. A
specification of the form \code{first:second} indicates the set of
terms obtained by taking the interactions of all terms in \code{first}
with all terms in \code{second}. The specification \code{first*second}
indicates the \emph{cross} of \code{first} and \code{second}. This is
the same as \code{first + second + first:second}, and exactly the same as
\code{"\link{glm}"} from the \link{stats} package.
}
\examples{
eglm(mpg ~ wt, family = gaussian, data = mtcars)
}
