% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proficiency_tools.R
\name{crosstabs}
\alias{crosstabs}
\title{Build a list of crosstabulations from a dataset}
\usage{
crosstabs(data, rowvar, colvar, varnames, digits = 2)
}
\arguments{
\item{data}{a data object, matrix or dataframe, that contains the categorical 
variables to compose the crosstab}

\item{rowvar}{a character value for the column in data that will be displayed on the rows
of the crosstab}

\item{colvar}{a character vlue for the column in data that will be displayed in columns of the 
crosstab}

\item{varnames}{a character vector of length two with the labels for rowvar and colvar
respectively}

\item{digits}{an integer for how much to round the proportion calculations by, 
default is 2}
}
\value{
a list with crosstab calculations
}
\description{
Build a list of crosstabulations from a dataset
}
\examples{
df<-data.frame(cbind(x=seq(1,3,by=1), y=sample(LETTERS[6:8],60,replace=TRUE)),
fac=sample(LETTERS[1:4], 60, replace=TRUE))
varnames<-c('Quality','Grade')
myCT <- crosstabs(df, rowvar = "x",colvar = "fac", varnames = varnames, digits =2)
}
