% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cutoff.R
\name{cutoff}
\alias{cutoff}
\title{A function to calculate thresholds of cumulative sums in a vector.}
\usage{
cutoff(x, cutoff, na.rm = TRUE)
}
\arguments{
\item{x}{a numeric vector, missing values are allowed}

\item{cutoff}{a user defined numeric value to stop the cutoff specified as
a proportion 0 to 1}

\item{na.rm}{logical, should missing values be excluded?}
}
\value{
An integer for the minimum number of elements necessary to reach cutoff
}
\description{
This function tells us how far we have to
go before reaching a cutoff in a variable
by sorting the vector, then finding how far
to go. Note that the cutoff is expressed in
percentage terms (fixed cumulative sum)
}
\details{
Calculates the distance through a numeric vector before a certain
proportion of the sum is reached by sorting the vector and calculating the
cumulative proportion of each element
}
\examples{
# for vector
a <- rnorm(100, mean=6, sd=1)
cutoff(a, .7) #return minimum number of elements to account 70 percent of total
}
\author{
Jared E. Knowles
}

