% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-enem.R
\name{get_enem}
\alias{get_enem}
\title{Get ENEM (Exame Nacional do Ensino Médio) data}
\usage{
get_enem(year, n_max = Inf, keep_zip = TRUE, quiet = FALSE)
}
\arguments{
\item{year}{The year of the exam (2009-2023).}

\item{n_max}{Maximum number of rows to read. Default is \code{Inf} (all rows).
Consider using a smaller value for exploration, as ENEM files
contain millions of rows.}

\item{keep_zip}{Logical. If \code{TRUE}, keeps the downloaded ZIP file in cache.}

\item{quiet}{Logical. If \code{TRUE}, suppresses progress messages.}
}
\value{
A tibble with the ENEM microdata in tidy format.
}
\description{
Downloads and processes microdata from ENEM, the Brazilian National
High School Exam. ENEM is used for university admissions and as a
high school equivalency exam.
}
\details{
ENEM is conducted annually by INEP and is the largest exam in Brazil,
with millions of participants. The microdata includes:
\itemize{
\item Participant demographics (age, sex, race, etc.)
\item Socioeconomic questionnaire responses
\item Scores for each test area
\item Essay scores
\item School information (when applicable)
}

\strong{Important notes:}
\itemize{
\item ENEM files are very large (several GB when extracted).
\item Use \code{n_max} to read a sample first for exploration.
\item Column names are standardized to lowercase with underscores.
\item Score variables start with \code{nu_nota_} prefix.
}
}
\section{Data dictionary}{

For detailed information about variables, see INEP's documentation:
\url{https://www.gov.br/inep/pt-br/acesso-a-informacao/dados-abertos/microdados/enem}
}

\examples{
\donttest{
# get a sample of 10000 rows for exploration
enem_sample <- get_enem(2023, n_max = 10000)

# get full data (warning: large file)
enem_2023 <- get_enem(2023)
}
}
