% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-censo-escolar.R
\name{get_censo_escolar}
\alias{get_censo_escolar}
\title{Get School Census (Censo Escolar) data}
\usage{
get_censo_escolar(year, uf = NULL, n_max = Inf, keep_zip = TRUE, quiet = FALSE)
}
\arguments{
\item{year}{The year of the census (2007-2024).}

\item{uf}{Optional. Filter by state (UF code or abbreviation).}

\item{n_max}{Maximum number of rows to read. Default is \code{Inf} (all rows).}

\item{keep_zip}{Logical. If \code{TRUE}, keeps the downloaded ZIP file in cache.}

\item{quiet}{Logical. If \code{TRUE}, suppresses progress messages.}
}
\value{
A tibble with school data in tidy format.
}
\description{
Downloads and processes microdata from the Brazilian School Census
(Censo Escolar), conducted annually by INEP. Returns school-level data
with information about infrastructure, location, and administrative details.
}
\details{
The School Census is the main statistical survey on basic education in
Brazil. It collects data from all public and private schools offering
basic education (early childhood, elementary, and high school).

\strong{Important notes:}
\itemize{
\item The microdata contains one row per school (~217,000 schools in 2023).
\item Column names are standardized to lowercase with underscores.
\item Use the \code{uf} parameter to filter by state for faster processing.
}
}
\section{Data dictionary}{

For detailed information about variables, see INEP's documentation:
\url{https://www.gov.br/inep/pt-br/acesso-a-informacao/dados-abertos/microdados/censo-escolar}
}

\examples{
\donttest{
# get schools data for 2023
escolas <- get_censo_escolar(2023)

# get schools from Sao Paulo state only
escolas_sp <- get_censo_escolar(2023, uf = "SP")

# read only first 1000 rows for exploration
escolas_sample <- get_censo_escolar(2023, n_max = 1000)
}
}
