% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{print_irt_stan}
\alias{print_irt_stan}
\title{View a table of parameter posteriors after using \code{irt_stan}}
\usage{
print_irt_stan(fit, data_list, probs = c(0.025, 0.25, 0.5, 0.75, 0.975),
  print_opts = list(digits = 3))
}
\arguments{
\item{fit}{A \code{stanfit-class} object created by \code{\link{irt_stan}}.}

\item{data_list}{A Stan data list created with \code{\link{irt_data}}.}

\item{probs}{A vector of quantiles for summarizing parameter posteriors.}

\item{print_opts}{Options passed to \code{\link[base]{print}} as a list.}
}
\description{
View a table of parameter posteriors after using \code{irt_stan}
}
\examples{
# Make a suitable data list:
X <- spelling[, 2:5]
W <- cbind(1, spelling[, 1])
spelling_list <- irt_data(X, W = W)

\dontrun{
# Fit a latent regression  2PL
twopl_fit <- irt_stan(spelling_list, model = "2pl_latent_reg.stan",
                      iter = 200, chains = 4)

# Get a table of parameter posteriors
print_irt_stan(twopl_fit, spelling_list)
}
}

