% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snl.R
\name{snl}
\alias{snl}
\title{Sensor Network Localization}
\usage{
snl(D, d, anchors = NULL)
}
\arguments{
\item{D}{The partial distance matrix specifying the known distances between nodes. 
If anchors is specified (and is a pxr matrix), the p final columns and p final rows specify the 
distances between the anchors specified in anchors.}

\item{d}{the dimension for the resulting completion}

\item{anchors}{a pxr matrix specifying the d dimensional locations of the p anchors. If the anchorless problem
is to be solved, anchors = NULL}
}
\value{
X the d-dimensional positions of the localized sensors. Note that it may be the case
that not all  sensors could be localized, in which case X contains the positions of only the localized sensors.
}
\description{
\code{snl} solves the sensor network problem with
partial distance (squared) matrix D, and anchor positions anchors, in
dimension d.
}
\details{
Set anchors=NULL to solve the anchorless (Euclidean distance matrix completion) 
problem in dimension d.

NOTE:  When anchors is specified, the distances between the anchors must be in the
bottom right corner of the matrix D, and anchors must have d columns.
}
\examples{
D <- matrix(c(0,NA,.1987,NA,.0595,NA,.0159,.2251,.0036,.0875,
              NA,0,.0481,NA,NA,.0515,NA,.2079,.2230,NA,
              .1987,.0481,0,NA,NA,.1158,NA,NA,.1553,NA,
              NA,NA,NA,0,NA,NA,NA,.2319,NA,NA,
              .0595,NA,NA,NA,0,NA,.1087,.0894,.0589,.0159,
              NA,.0515,.1158,NA,NA,0,NA,NA,NA,NA,
              .0159,NA,NA,NA,.1087,NA,0,.3497,.0311,.1139,
              .2251,.2079,NA,.2319,.0894,NA,.3497,0,.1918,.1607,
              .0036,.2230,.1553,NA,.0589,NA,.0311,.1918,0,.1012,
              .0875,NA,NA,NA,.0159,NA,.1139,.1607,.1012,0),nrow=10, byrow=TRUE)
              
anchors <- matrix(c(.5131,.9326,
                    .3183,.3742,
                    .5392,.7524,
                    .2213,.7631), nrow=4,byrow=TRUE)
d <- 2

#Anchorless Problem
edmc(D, method="snl", d=2, anchors=NULL)

#Anchored Problem
edmc(D, method="snl", d=2, anchors=anchors)

}
\references{
Nathan Krislock and Henry Wolkowicz. Explicit sensor network localization
using semidefinite representations and facial reductions. SIAM Journal on
Optimization, 20(5):2679-2708, 2010.
}
