% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primPath.R
\name{primPath}
\alias{primPath}
\title{Minimum Spanning Tree Path}
\usage{
primPath(A, start)
}
\arguments{
\item{A}{the distance matrix for which the minimum spanning tree path will be created}

\item{start}{the starting node for the path}
}
\value{
return a 2x(n-1) matrix, where row 1 contains the parent nodes of the MST path, and row 2 contains the corresponding child nodes.
}
\description{
\code{primPath} Given a starting node, creates the minimum spanning tree path through a point configuration.
}
\details{
Given a starting node, compute Prim's algorithm, resulting in the path taken to construct the minimum spanning tree.
}
\examples{
A <- dist(cbind(rnorm(100,0,1),rnorm(100,0,1)))
primPath(as.matrix(A),1)
primPath(as.matrix(A),2)

}

