% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOutcomes.R
\name{getOutcomes}
\alias{getOutcomes}
\title{Extract outcomes from list of weightmatrices.}
\usage{
getOutcomes(wmlist, extra.check = FALSE)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{extra.check}{Logical: whether or not to collect all cues from all 
weightmatrices in the list. Note that this slows down the process and 
should not result in different findings. Default is FALSE.}
}
\value{
Vector with outcomes.
}
\description{
Extract outcomes from list of weightmatrices.
}
\examples{
# load example data:
data(dat)
# prepare training data:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
train <- createTrainingData(dat)
# learning:
wm <- RWlearning(train)
# retrieve cues from wm list:
getOutcomes(wm)
# or this version (which takes more time):
system.time({getOutcomes(wm, extra.check=TRUE)})
system.time({getOutcomes(wm)})

}
\seealso{
\code{\link{getCues}}, \code{\link{getValues}}
}
\author{
Jacolien van Rij
}
