% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activationsMatrix.R
\name{activationsMatrix}
\alias{activationsMatrix}
\title{Calculate the activations for one or a set of cues.}
\usage{
activationsMatrix(
  wm,
  cues,
  split = "_",
  select.outcomes = NULL,
  init.value = 0,
  normalize = FALSE
)
}
\arguments{
\item{wm}{A weightmatrix, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{cues}{String or vector of strings. Each string represents a set of 
cues, separated by \code{split}, for which the activations will be 
calculated. Note: the activations will be calculated for all provided cues 
together, assuming these occurred in one learning event.}

\item{split}{String, separator between cues.}

\item{select.outcomes}{Optional selection of outcomes to limit the 
number of activations that are returned. The value of NULL (default) will 
return all activations (for each outcome in \code{wm}). 
Note that specified values that are not in 
the weightmatrix will return the initial value without error or 
warning. Please use \code{\link{getValues}} for returning all 
outcomes in the data.}

\item{init.value}{Value of activations for non-existing connections. 
Typically set to 0.}

\item{normalize}{Logical: whether or not the activation is normalized by 
dividing the total activation by the number of cues. Default is FALSE. If 
set to TRUE, the activation reflects the average activation per cue.}
}
\value{
Vector or data frame.
}
\description{
Calculate the activations for one or a set of cues. 
The values are returned as vector or data frame.
}
\examples{
# load example data:
data(dat)

# setup data:
newdat <- data.frame(Cues =paste("BG", dat$Shape, dat$Color, sep="_"),
   Outcomes  = dat$Category,
   Frequency = dat$Frequency2)
train  <- createTrainingData(newdat)
# learning:
wm     <- RWlearning(train)

# calculate activations for all outcomes:
mat    <- getWM(wm)
activationsMatrix(mat, cues="BG_tree_green")
# only accepts one set of cues - in this case all cues 
# are combined:
activationsMatrix(mat, cues=c("BG_tree", "BG_tree_brown"))
# ... which is the same as this:
activationsMatrix(mat, cues=c("BG", "BG", "tree", "tree", "brown"))
# now select one outcome:
activationsMatrix(mat, cues=c("BG", "tree"), select.outcomes="vehicle")
# cues/outcomes not in matrix:
activationsMatrix(mat, cues=c("na"), select.outcomes="new")

}
\seealso{
\code{\link{getWeightsByCue}},
\code{\link{getWeightsByOutcome}}

Other functions for calculating activations: 
\code{\link{activationsCueSet}()},
\code{\link{activationsEvents}()},
\code{\link{activationsOutcomes}()},
\code{\link{getActivations}()}
}
\author{
Jacolien van Rij
}
\concept{functions for calculating activations}
