% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{package}
\name{editrules_package}
\alias{editrules}
\alias{editrules-package}
\alias{editrules_package}
\title{An overview of the function of package \code{editrules}}
\description{
Please note: active development has moved to packages 'validate' and 'errorlocate'. Facilitates reading and manipulating (multivariate) data restrictions (edit rules) on numerical and categorical data. Rules can be defined with common R syntax and parsed to an internal (matrix-like format). Rules can be manipulated with variable elimination and value substitution methods, allowing for feasibility checks and more. Data can be tested against the rules and erroneous fields can be found based on Fellegi and Holt's generalized principle. Rules dependencies can be visualized with using the 'igraph' package.
}
\section{NOTE}{

This package is no longer under active development. The package is superseded
by R packages \href{https://CRAN.R-project.org/package=validate}{validate}
for data validation and
\href{https://CRAN.R-project.org/package=errorlocate}{errorlocate}
for error localization. We urge new users to use those packages instead.

The \code{editrules} package aims to provide an environment to conveniently
define, read and check recordwise data constraints including 
\itemize{
\item{Linear (in)equality constraints for numerical data},
\item{Constraints on value combinations of categorical data}
\item{Conditional constraints on numerical and/or mixed data}
}
In literature these constraints, or restrictions are refered to as ``edits''. 
\code{editrules} can perform common rule
set manipulations like variable elimination and value substitution, and 
offers error localization functionality based on the
(generalized) paradigm of Fellegi and Holt. Under this paradigm, one determines
the smallest (weighted) number of variables to adapt such that no (additional or derived) 
rules are violated. The paradigm is based on the assumption that errors
are distributed randomly over the variables and there is no detectable cause of
error. It also decouples the detection of corrupt variables from their
correction. For some types of error, such as sign flips, typing errors or
rounding errors, this assumption does not hold. These errors can be detected
and are closely related to their resolution. The reader is referred to the
\pkg{deducorrect} package for treating such errors.
}

\section{I. Define edits}{


\code{editrules} provides several methods for creating edits from a \code{character}
, \code{expression}, \code{data.frame} or a text file.
\tabular{ll}{
  \code{\link{editfile}}     \tab Read  conditional numerical, numerical and categorical constraints from textfile \cr
  \code{\link{editset}}     \tab Create conditional numerical, numerical and categorical constraints \cr
  \code{\link{editmatrix}} \tab Create a linear constraint matrix for numerical data \cr
  \code{\link{editarray}}  \tab Create value combination constraints for categorical data \cr
}
}

\section{II. Check and find errors in data}{


\code{editrules} provides several method for checking \code{data.frame}s with edits
\tabular{ll}{
  \code{\link{violatedEdits}} \tab Find out which record violates which edit. \cr
  \code{\link{localizeErrors}}  \tab Localize erroneous fields using Fellegi and Holt's principle. \cr
  \code{\link{errorLocalizer}}  \tab Low-level error localization function using B&B algorithm \cr
}
Note that you can call \code{plot}, \code{summary} and \code{print}  on results of these functions.
}

\section{IV. Manipulate and check edits}{


\code{editrules} provides several methods for manipulating edits
\tabular{ll}{
  \code{\link{substValue}} \tab Substitute a value in a set of rules \cr
  \code{\link{eliminate}} \tab Derive implied rules by variable elimination \cr
  \code{\link{reduce}} \tab Remove unconstraint variables \cr
  \code{\link{isFeasible}} \tab Check for contradictions \cr
  \code{\link{duplicated}} \tab Find duplicated rules \cr
  \code{\link{blocks}} \tab Decompose rules into independent blocks \cr
  \code{\link{disjunct}} \tab Decouple conditional edits into disjunct edit sets\cr
  \code{\link{separate}} \tab Decompose rules in blocks and decouple conditinal edits \cr
  \code{\link{generateEdits}} \tab Generate all nonredundant implicit edits (\code{\link{editarray}} only) \cr
}
}

\section{V. Plot and coerce edits}{


\code{editrules} provides several methods for plotting and coercion.
\tabular{ll}{
  \code{\link{editrules.plotting}} \tab Plot edit-variable connectivity graph \cr
  \code{\link{as.igraph}} \tab Coerce to edit-variable connectivity \code{igraph} object \cr
  \code{as.character} \tab Coerce edits to \code{character} representation \cr
  \code{as.data.frame} \tab Store \code{character} representation in \code{data.frame} \cr
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/data-cleaning/editrules}
  \item Report bugs at \url{https://github.com/data-cleaning/editrules/issues}
}

}
