% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_df.R
\name{rows_update.data.frame}
\alias{rows_update.data.frame}
\title{rows_update implementation for data.frame backends.}
\usage{
\method{rows_update}{data.frame}(x, y, by = NULL, match = NULL, ..., copy = FALSE, in_place = FALSE)
}
\arguments{
\item{x, y}{A pair of data frames or data frame extensions (e.g. a tibble).
\code{y} must have the same columns of \code{x} or a subset.}

\item{by}{An unnamed character vector giving the key columns. The key columns
must exist in both \code{x} and \code{y}. Keys typically uniquely identify each row,
but this is only enforced for the key values of \code{y} when \code{rows_update()},
\code{rows_patch()}, or \code{rows_upsert()} are used.

By default, we use the first column in \code{y}, since the first column is
a reasonable place to put an identifier variable.}

\item{match}{named list consisting out of two equal length \code{data.frame}'s with columns defined in \code{by}.
This allows for updates of columns defined in by.}

\item{...}{Other parameters passed onto methods.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{in_place}{Should \code{x} be modified in place? This argument is only
relevant for mutable backends (e.g. databases, data.tables).

When \code{TRUE}, a modified version of \code{x} is returned invisibly;
when \code{FALSE}, a new object representing the resulting changes is returned.}
}
\value{
An object of the same type as \code{x}. The order of the rows and columns of \code{x}
is preserved as much as possible. The output has the following properties:
\itemize{
\item \code{rows_update()} and \code{rows_patch()} preserve the number of rows;
\code{rows_insert()}, \code{rows_append()}, and \code{rows_upsert()} return all existing
rows and potentially new rows; \code{rows_delete()} returns a subset of the
rows.
\item Columns are not added, removed, or relocated, though the data may be
updated.
\item Groups are taken from \code{x}.
\item Data frame attributes are taken from \code{x}.
}

If \code{in_place = TRUE}, the result will be returned invisibly.
}
\description{
rows_update implementation for data.frame backends.
}
\author{
Jasper Schelfhout
}
