% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kitchen.R
\name{Kitchen}
\alias{Kitchen}
\title{A manipulator for the edbl_design.}
\description{
A manipulator for the edbl_design.

A manipulator for the edbl_design.
}
\details{
Internal functions should create a new Kitchen object.
The Kitchen contains a set of operations to manipulate the nodes and edges of
the edibble design object.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{design}}{An edibble design object
Initialise function}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fct_nodes}}{Get the factor nodes}

\item{\code{lvl_nodes}}{Get the level nodes}

\item{\code{fct_edges}}{Get the factor edges}

\item{\code{lvl_edges}}{Get the level edges}

\item{\code{fct_n}}{Get the number of nodes in factor graph}

\item{\code{lvl_n}}{Get the number of nodes in level graph}

\item{\code{fct_last_id}}{Get the last factor id.}

\item{\code{lvl_last_id}}{Get the last level id.}

\item{\code{fct_leaves}}{Get the leave factor ids.}

\item{\code{rcrd_ids}}{Get the ids for all edbl_rcrd factors.}

\item{\code{unit_ids}}{Get the ids for all edbl_unit factors.}

\item{\code{trt_ids}}{Get the ids for all edbl_trt factors.}

\item{\code{trt_names}}{Get the node labels for treatments}

\item{\code{unit_names}}{Get the node labels for units}

\item{\code{rcrd_names}}{Get the node labels for record}

\item{\code{is_connected}}{Check if nodes are connected.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Kitchen-new}{\code{Kitchen$new()}}
\item \href{#method-Kitchen-fct_id}{\code{Kitchen$fct_id()}}
\item \href{#method-Kitchen-lvl_id}{\code{Kitchen$lvl_id()}}
\item \href{#method-Kitchen-fct_names}{\code{Kitchen$fct_names()}}
\item \href{#method-Kitchen-lvl_names}{\code{Kitchen$lvl_names()}}
\item \href{#method-Kitchen-append_fct_nodes}{\code{Kitchen$append_fct_nodes()}}
\item \href{#method-Kitchen-append_lvl_nodes}{\code{Kitchen$append_lvl_nodes()}}
\item \href{#method-Kitchen-append_fct_edges}{\code{Kitchen$append_fct_edges()}}
\item \href{#method-Kitchen-append_lvl_edges}{\code{Kitchen$append_lvl_edges()}}
\item \href{#method-Kitchen-fct_class}{\code{Kitchen$fct_class()}}
\item \href{#method-Kitchen-lvl_class}{\code{Kitchen$lvl_class()}}
\item \href{#method-Kitchen-fct_child}{\code{Kitchen$fct_child()}}
\item \href{#method-Kitchen-lvl_child}{\code{Kitchen$lvl_child()}}
\item \href{#method-Kitchen-fct_parent}{\code{Kitchen$fct_parent()}}
\item \href{#method-Kitchen-lvl_parent}{\code{Kitchen$lvl_parent()}}
\item \href{#method-Kitchen-fct_ancestor}{\code{Kitchen$fct_ancestor()}}
\item \href{#method-Kitchen-lvl_ancestor}{\code{Kitchen$lvl_ancestor()}}
\item \href{#method-Kitchen-fct_levels}{\code{Kitchen$fct_levels()}}
\item \href{#method-Kitchen-setup_data}{\code{Kitchen$setup_data()}}
\item \href{#method-Kitchen-add_anatomy}{\code{Kitchen$add_anatomy()}}
\item \href{#method-Kitchen-fct_exists}{\code{Kitchen$fct_exists()}}
\item \href{#method-Kitchen-trts_exists}{\code{Kitchen$trts_exists()}}
\item \href{#method-Kitchen-units_exists}{\code{Kitchen$units_exists()}}
\item \href{#method-Kitchen-rcrds_exists}{\code{Kitchen$rcrds_exists()}}
\item \href{#method-Kitchen-clone}{\code{Kitchen$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-new"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$new(design = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{design}}{An edibble design.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_id"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_id}{}}}
\subsection{Method \code{fct_id()}}{
Get the id based on either the name of the factor node or
the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_id(name = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the vertex.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-lvl_id"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-lvl_id}{}}}
\subsection{Method \code{lvl_id()}}{
Get the id based on name of level node
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$lvl_id(name = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the vertex.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_names"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_names}{}}}
\subsection{Method \code{fct_names()}}{
Get the factor names based on id or class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_names(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-lvl_names"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-lvl_names}{}}}
\subsection{Method \code{lvl_names()}}{
Get the level names based on id or class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$lvl_names(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-append_fct_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-append_fct_nodes}{}}}
\subsection{Method \code{append_fct_nodes()}}{
Given node data, append the factor nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$append_fct_nodes(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The nodes data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-append_lvl_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-append_lvl_nodes}{}}}
\subsection{Method \code{append_lvl_nodes()}}{
Given node data, append the level nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$append_lvl_nodes(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The nodes data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-append_fct_edges"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-append_fct_edges}{}}}
\subsection{Method \code{append_fct_edges()}}{
Given edge data, append the factor edges
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$append_fct_edges(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The nodes data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-append_lvl_edges"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-append_lvl_edges}{}}}
\subsection{Method \code{append_lvl_edges()}}{
Given edge data, append the level edges
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$append_lvl_edges(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The nodes data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_class"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_class}{}}}
\subsection{Method \code{fct_class()}}{
Get the class of the vertex given the factor id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_class(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-lvl_class"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-lvl_class}{}}}
\subsection{Method \code{lvl_class()}}{
Get the class of the vertex given the level id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$lvl_class(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_child"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_child}{}}}
\subsection{Method \code{fct_child()}}{
Get the factor child ids. If \code{class} is
supplied then the child has to fit \code{class}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_child(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-lvl_child"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-lvl_child}{}}}
\subsection{Method \code{lvl_child()}}{
Get the level child ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$lvl_child(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_parent"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_parent}{}}}
\subsection{Method \code{fct_parent()}}{
Get the factor parent ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_parent(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-lvl_parent"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-lvl_parent}{}}}
\subsection{Method \code{lvl_parent()}}{
Get the level parent ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$lvl_parent(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_ancestor"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_ancestor}{}}}
\subsection{Method \code{fct_ancestor()}}{
Get the factor ancestor ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_ancestor(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-lvl_ancestor"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-lvl_ancestor}{}}}
\subsection{Method \code{lvl_ancestor()}}{
Get the level ancestor ids
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$lvl_ancestor(id = NULL, class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_levels"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_levels}{}}}
\subsection{Method \code{fct_levels()}}{
Get the levels for each factor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_levels(id = NULL, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the corresponding node.}

\item{\code{name}}{The name of the vertex.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-setup_data"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-setup_data}{}}}
\subsection{Method \code{setup_data()}}{
Setup the node and edge data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$setup_data(fresh, name, class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fresh}}{The value of the new graph structure to add.}

\item{\code{name}}{The name of the vertex.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-add_anatomy"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-add_anatomy}{}}}
\subsection{Method \code{add_anatomy()}}{
Add the anatomy structure
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$add_anatomy(fresh, name, class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fresh}}{The value of the new graph structure to add.}

\item{\code{name}}{The name of the vertex.}

\item{\code{class}}{The class for the vertex/node.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-fct_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-fct_exists}{}}}
\subsection{Method \code{fct_exists()}}{
One of \code{name}, \code{id} or \code{class} is defined to check if it exists.
If more than one of the arguments \code{name}, \code{id} and \code{class} are supplied, then
the intersection of it will be checked.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$fct_exists(name = NULL, id = NULL, class = NULL, abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the vertex.}

\item{\code{id}}{The id of the corresponding node.}

\item{\code{class}}{The class for the vertex/node.}

\item{\code{abort}}{A logical value to indicate whether to abort if it doesn't exist.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-trts_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-trts_exists}{}}}
\subsection{Method \code{trts_exists()}}{
Check if treatment exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$trts_exists(abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-units_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-units_exists}{}}}
\subsection{Method \code{units_exists()}}{
Check if unit exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$units_exists(abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-rcrds_exists"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-rcrds_exists}{}}}
\subsection{Method \code{rcrds_exists()}}{
Check if record exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$rcrds_exists(abort = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abort}}{Whether to abort.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kitchen-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Kitchen-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kitchen$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
