% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/download_fillings.R
\name{DownloadFillings}
\alias{DownloadFillings}
\title{Retrieve the EDGAR fillings from SEC.org site.}
\usage{
DownloadFillings(year, cik.no, form.type)
}
\arguments{
\item{year}{An integer specifies year for which EDGAR filings are to be downloaded.}

\item{cik.no}{An integer containing specific CIK number for which EDGAR filings are
to be downloaded. cik.no = 'ALL' if required to download for all CIK's.}

\item{form.type}{character string containing specific Form-type to be downloaded.
form.type = 'ALL' if required to download all form-types.}
}
\value{
Function download the EDGAR filings from \url{ftp://ftp.sec.gov/edgar} site
and return download status dataframe.
}
\description{
\code{DownloadFillings} retrieve the EDGAR fillings for the specified CIK, form-type,
and year mentioned in the function parameters.
}
\details{
DownloadFillings function takes year, form_type, and CIK as an input. It ask the
user to locate the working directory. Working directory should contain 'Master Files'
directory containing master Rda files for specific years downloaded using
\link[edgar]{DownloadMaster} function. New directory 'EDGAR Fillings' will be created
which stores all downloaded fillings. Please note, for all other functions in this
package needs to locate the same working directory.
}
\examples{
\dontrun{

rep <- DownloadFillings(1994, 100030, 'ALL')
## download all fillings filed by the firm with CIK=100030 in the year 1994. Generate the report
## in dataframe.

rep <- DownloadFillings(2006, 1000180, '10-K')
## download '10-K' fillings filed by the firm with CIK=1000180 in the year 2006.
## Generate the report in dataframe.
}
}

