% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateData}
\alias{generateData}
\title{Generate Simulation Data of Up-and-Down Experiment}
\usage{
generateData(number, start, doseStep = 1, distribution = c("Normal",
  "Triangle", "Chi-square"), normalMean = 0, normalStd = 1, triMean = 0,
  triWidth = 2, chiDegree = 1)
}
\arguments{
\item{number}{The number of experiments in a trail.}

\item{start}{The first dose level given in this trail.}

\item{doseStep}{A fix value  that represents the difference between two adjacent dose levels.}

\item{distribution}{The tolerance distribution, including normal, triangle and chi-square
distribution, and the default distribution is N(0, 1).}

\item{normalMean}{Parameter mean of normal distribution, the default value is 0.}

\item{normalStd}{Parameter std of normal distribution, the default value is 1.}

\item{triMean}{Parameter mean of triangle distribution, the default value is 0.}

\item{triWidth}{Parameter width of triangle distribution, the default value is 2.}

\item{chiDegree}{Parameter degree of freedom of chi-square distribution, the default value is 1.}
}
\value{
A data frame.
}
\description{
The function is used to generate simulation data of up-and-down
experiment, and provide three cases that tolerance distribution obeys normal,
triangle or chi-square distribution.
}
\examples{
library(ed50)
generateData(number = 20, start = 2, doseStep = 0.2, distribution = 'Normal')
generateData(number = 40, start = 2, doseStep = 0.2, distribution = 'Chi-square')
}
