% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockBootID.R
\name{BlockBootID}
\alias{BlockBootID}
\title{Construct a moving block bootstrap resampling scheme}
\usage{
BlockBootID(
  x,
  y,
  block_L,
  nBoot = 499,
  Grid_space,
  lookuptables.folderpath = NA,
  shape = "disc",
  ...
)
}
\arguments{
\item{x}{the easting of spatial coordinate for the site.}

\item{y}{the northing of the spatial coordinate for the site.}

\item{block_L}{the size of the spatial blocks to be resampled.}

\item{nBoot}{the number of resamples required (defaults to 499).}

\item{Grid_space}{the resolution of the lattice used to sample centres of spatial blocks.
Defaults to a third of the resolution of \code{block_Ls}.}

\item{lookuptables.folderpath}{(optional) path to a directory where lookup tables can be found
that assign observations to spatial blocks. Such tables would considerably speed up the process.}

\item{shape}{shape of the spatial blocks to resample. Default is \code{disc}, but \code{square} 
tiles can also be specified.}

\item{...}{additional arguments passed to \code{resample_blocks_by_area}.}
}
\value{
A matrix of IDs for each moving block bootstrap resample, with different
resamples in rows and observations in columns.
}
\description{
A spatial moving block bootstrap resampling scheme is constructed, that can then
be used in resampling-based inference (e.g. using \code{\link[mvabund]{anova.manyglm}}).
Blocks are constructed as discs or tiles of observations of a user-specified size and shape.
}
\details{
A spatial moving block bootstrap resampling scheme is constructed, that can then
be used in resampling-based inference. A matrix of IDs is returned, with different resamples 
in different rows of the matrix, which can be used as input to functions designed for 
resampling-based inference (such as \code{\link[mvabund]{anova.manyglm}}).

Blocks are constructed as discs or tiles of observations, whose size is controlled by \code{blockl_L},
these blocks are kept together in resampling. The centre of each block is chosen 
at random along a lattice specified via \code{Grid_space}. 

The most computationally intensive part of this process is working out which observations 
belong in which blocks. If repeated analyses are to be undertaken in the same spatial domain 
using the same sites, it is best to run this process only once and save the result as a set of
lookup tables via the function \bold{Eve to advise what function to use}.
Then the path to the directory containing these tables is specified via \code{lookuptables.folderpath}
and the whole thing runs heaps faster.
}
\examples{
\donttest{
data(Myrtaceae)
# fit a lm:
library(mvabund)
Myrtaceae$logrich=log(Myrtaceae$richness+1)
mft_richAdd = manylm(logrich~soil+poly(TMP_MAX,degree=2)+
                     poly(TMP_MIN,degree=2)+poly(RAIN_ANN,degree=2),
                                        data=Myrtaceae)
                                        
# construct a boot ID matrix: 
BootID = BlockBootID(x = Myrtaceae$X, y = Myrtaceae$Y, block_L = 20,
            nBoot = 199, Grid_space = 5)
anova(mft_richAdd,resamp="case",bootID=BootID)
}

}
\seealso{
\code{\link[mvabund]{anova.manyglm}}, \code{\link{lm}}
}
\author{
Eve Slavich <eve.slavich@unsw.edu.au>
}
