#' Global Plants data
#'
#' Data inspired by a worldwide study of plant height and its association with climate and latitude (Moles \emph{et al.} 2009).
#' Height is recorded for one dominant plant at each of 178 sites, along with dozens of climatic variables extracted from BIOCLIM.
#' Sites, climate data and species lists come from Moles \emph{et al.} (2009) but height data are not actually field measurements,
#' due to data unavailability. Instead height has been taken from species descriptions available on Google, accessed 7/1/21.
#' 
#' @docType data
#'
#' @usage data(globalPlants)
#'
#' @format A dataframe containing a whole bunch of stuff, the main things being:\describe{
#' \item{height}{Maximum plant height, in metres, taken from species descriptions on Google (where available)}
#' \item{lat}{latitude of the site this plant was found at}
#' \item{temp}{average daily maximum temperature}
#' \item{rain}{total annual precipitation}
#' \item{rain.wetm}{Rainfall in the wettest month}
#' }
#'
#' @keywords datasets
#'
#' @references Moles \emph{et al.} (2009) Global patterns in plant height.
#' Journal of Ecology \bold{97}, 923-932.
#'
#' @examples
#' data(globalPlants)
#' plot(height~lat,data=globalPlants)
#' 
#' 
#' 
"globalPlants"