% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ee_observations}
\alias{ee_observations}
\title{Observations List}
\usage{
ee_observations(page = NULL, page_size = 1000, country = "United States",
  state_province = NULL, county = NULL, kingdom = NULL, phylum = NULL,
  order = NULL, clss = NULL, family = NULL, genus = NULL,
  scientific_name = NULL, kingdom__exact = NULL, phylum__exact = NULL,
  order__exact = NULL, clss__exact = NULL, family__exact = NULL,
  genus__exact = NULL, scientific_name__exact = NULL, remote_id = NULL,
  collection_code = NULL, source = NULL, min_date = NULL,
  max_date = NULL, georeferenced = FALSE, bbox = NULL, exclude = NULL,
  extra = NULL, quiet = FALSE, progress = TRUE, foptions = list())
}
\arguments{
\item{page}{Page number}

\item{page_size}{The number of observations per page returned by the query. The package default is \code{25} observations. The API default, however, is \code{10}. Setting this number higher will require fewer calls (i.e. pages) but a large size may also fail or timeout.}

\item{country}{country name}

\item{state_province}{description needed.}

\item{county}{California county. See \code{data(california_counties)}}

\item{kingdom}{kingdom name}

\item{phylum}{phylum name}

\item{order}{order name}

\item{clss}{class name}

\item{family}{family name}

\item{genus}{genus name.}

\item{scientific_name}{A full scientific name}

\item{kingdom__exact}{exact kingdom name}

\item{phylum__exact}{exact phylum name}

\item{order__exact}{exact order name}

\item{clss__exact}{class name}

\item{family__exact}{exact family name}

\item{genus__exact}{exact genus name}

\item{scientific_name__exact}{exact scientific name}

\item{remote_id}{remote ID}

\item{collection_code}{collections code}

\item{source}{data source. See \code{\link{ee_sources}}}

\item{min_date}{Lower date bound. Most be in format Y-m-D h:m:s. This package uses lubridate's \code{ymd_hms} function to format dates.}

\item{max_date}{upper date bound. Most be in format Y-m-D h:m:s. This package uses lubridate's \code{ymd_hms} function to format dates.}

\item{georeferenced}{Default is \code{FALSE}. Set to \code{TRUE} to return only georeferenced records.}

\item{bbox}{Set a bounding box for your search. Use format \code{bbox=-124,32,-114,42}. Order is min Longitude , min Latitude , max Longitude , max Latitude. Use \code{http://boundingbox.klokantech.com/} this website to quickly grab a bounding box (set format to csv on lower right)}

\item{exclude}{Default is \code{NULL}. Pass a list of fields to exclude.}

\item{extra}{Default is \code{NULL}. Pass a list of extra fields to be returned. Additional fields include:
# "id", "record", "source", "remote_resource", "begin_date", "end_date",
# "collection_code", "institution_code", "state_province", "county",
# "last_modified", "original_id", "geometry", "coordinate_uncertainty_in_meters"
# "md5", "scientific_name", "observation_type", "date_precision", "locality"
# "earliest_period_or_lowest_system", "latest_period_or_highest_system", "kingdom"
# "phylum", "clss", "order", "family", "genus", "specific_epithet",
# "infraspecific_epithet", "minimum_depth_in_meters", "maximum_depth_in_meters",
# "maximum_elevation_in_meters", "minimum_elevation_in_meters", "catalog_number"
# "preparations", "sex", "life_stage", "water_body", "country", "individual_count",
"associated_resources"}

\item{quiet}{Default is \code{FALSE}. Set to \code{TRUE} to supress messages.}

\item{foptions}{A list of additional arguments for \code{httr}. There is no reason to use this argument except for debugging purposes.}

\item{progress}{Progress bar is set to \code{TRUE} by default. Use \code{FALSE} especially when calling functions inside documents.}
}
\value{
\code{data.frame}
}
\description{
API endpoint that represents a list of observations.
}
\examples{
# vulpes <- ee_observations(genus = "vulpes")
\dontrun{
# pinus <- ee_observations(scientific_name = "Pinus", page_size = 100)
# lynx_data <- ee_observations(genus = "Lynx")
# Georeferenced data only
# lynx_data <- ee_observations(genus = "Lynx", georeferenced = TRUE)
# animalia <- ee_observations(kingdom = "Animalia")
# Artemisia <- ee_observations(scientific_name = "Artemisia douglasiana")
# asteraceae <- ee_observationss(family = "asteraceae")
# vulpes <- ee_observations(genus = "vulpes")
# Anas <- ee_observations(scientific_name = "Anas cyanoptera", page = "all")
# loons <- ee_observations(scientific_name = "Gavia immer", page = "all")
# plantae <- ee_observations(kingdom = "plantae")
# chordata <- ee_observations(phylum = "chordata")
# Class is clss since the former is a reserved keyword in SQL.
# aves <- ee_observations(clss = "aves")
# You can also exclude fields using the exclude field
#  aves <- ee_observations(clss = "aves", exclude = "remote_resource")
#  aves <- ee_observations(clss = "aves", exclude = "source,remote_resource")
#  or request additional fields using extra
#  aves <- ee_observations(clss = "aves", extra = "kingdom,genus")
# aves <- ee_observations(clss = "aves", bbox = '-124,32,-114,42')
# aves <- ee_observations(clss = "aves", county = "Alameda county")
}
}

