% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durbinH.r
\name{durbinH}
\alias{durbinH}
\title{Calculate Durbin's h-statistic}
\usage{
durbinH(model, ylag1var)
}
\arguments{
\item{model}{The model being assessed}

\item{ylag1var}{The variable in the model that represents the lag of the y-term}
}
\value{
Numeric Durbin's h statistic
}
\description{
Calculates Durbin's h-statistic for autoregressive models.
}
\details{
Using the Durbin-Watson (DW) test for autoregressive models is inappropriate because the DW test itself 
tests for first order autocorrelation. This doesn't apply to an ECM model, for which the DW test is 
still valid, but the durbinH function in included here in case an autoregressive model has been built.
If Durbin's h-statistic is greater than 1.96, it is likely that autocorrelation exists.
}
\examples{
#Build a simple AR1 model to predict performance of the Wilshire 5000 Index
data(Wilshire)
Wilshire$Wilshire5000Lag1 <- c(NA, Wilshire$Wilshire5000[1:(nrow(Wilshire)-1)])
Wilshire <- Wilshire[complete.cases(Wilshire),]
AR1model <- lm(Wilshire5000 ~ Wilshire5000Lag1, data=Wilshire)

#Check Durbin's h-statistic on AR1model
durbinH(AR1model, "Wilshire5000Lag1")
#The h-statistic is 4.23, which means there is likely autocorrelation in the data.

}
\seealso{
\code{lm}
}
