% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_gen_err_ev1}
\alias{ec_gen_err_ev1}
\title{Simulate error realization from EV1 distribution}
\usage{
ec_gen_err_ev1(ec_dem, draws, seed = NULL)
}
\arguments{
\item{ec_dem}{discrete or volumetric choice data, with or without x}

\item{draws}{draws from volumetric demand model}

\item{seed}{seed for reproducible error realisations; seet is automatically reset of running this function}
}
\value{
error realizations
}
\description{
Simulate error realization from EV1 distribution
}
\examples{
data(icecream)
#run MCMC sampler (use way more than 50 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<100) \%>\% 
vd_est_vdm(R=100, keep=1)
#generate error realizations
errs<- ec_gen_err_ev1(icecream \%>\% dplyr::filter(id<100), icecream_est, seed=123)
}
