% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfHT.R
\name{ecdfHT.fit}
\alias{ecdfHT.fit}
\alias{ecdfHT.fit.tails}
\title{Fit heavy tailed data with a semi-parameteric model}
\usage{
ecdfHT.fit(p, transform.info, x.min = NA, x.max = NA, add.to.plot = TRUE,
  weights = "var", ...)

ecdfHT.fit.tails(p, transform.info, weights, add.to.plot = TRUE, ...)
}
\arguments{
\item{p}{Vector of 2 probabilities that identify the quantile where data is cut to fit power decay on
lower/upper tail. Set tail.p[1]=0 to exclude lower tail fit; tail.p[2]=1 to exclude upper tail fit.}

\item{transform.info}{List containing transformation information, returned from \code{ecdfHT}}

\item{x.min}{Number describing cut-off of lower tail}

\item{x.max}{Number describing cut-off of upper tail}

\item{add.to.plot}{Boolean indicating whether or not the interpolation is plotted}

\item{weights}{'none' to do unweighted regression or 'var' to use weighted regression on tail with weights proportional to variance of quantile}

\item{...}{Optional parameters passed to plot routines, e.g. col='red'}
}
\value{
An object of class 'ecdfHT.fit' specifying the interpolation. The fields in the value are:
\describe{
\item{scale.q}{vector of length 3, copied from the input argument}
\item{scale.x}{vector of length 3, the quantiles from the data corresponding to scale.q}
\item{xsort}{vector of the sorted, unique data values}
\item{ecdf}{nonstandard empirical cdf, see details}
\item{xx}{transformed x values: xx[i]=h(xsort[i])}
\item{yy}{transformed p values: yy[i]=g(ecdf[i])}
\item{cdf.spline}{monotonic spline function used to compute the cdf}
\item{inf.cdf.spline}{monotonic spline function used to compute the inverse of the cdf}
\item{tail.p}{vector of length 2; probabilities saying where the lower and upper tails begin.
    Note these are generally not the exact values of input variable p, rather they are the closest values to those found in ecdf}
\item{tail.x}{vector of length 2; x values where the lower and upper tails begin}
\item{tail.c}{vector of length 2; tail constants for lower and upper powerlaw fit}
\item{tails.slope}{vector of length 2; slope of tails on transformed plot}
\item{tail.alpha}{vector of length 2; exponents for lower and upper power law fit}
\item{tail.m}{integer vector of length 2; indices in xsort where tails begin }
\item{weights}{copy of input variable weights}
}
}
\description{
Compute an interpolation of the transformed cdf in the middle with parametric power law decay on the tails.
}
\examples{
x <- rcauchy( 1000 )
a <- ecdfHT( x )
fit <- ecdfHT.fit( c(.1,.9), a, col='red' )
str(fit)

}

