% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_write.R
\name{ebv_write}
\alias{ebv_write}
\title{Write the extracted data on your disk as a GeoTiff}
\usage{
ebv_write(
  data,
  outputpath,
  epsg = 4326,
  extent = c(-180, 180, -90, 90),
  type = "FLT8S",
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{Your data object. May be SpatRaster, array, DelayedMatrix or list
of DelayedMatrix (see return values of \code{\link[=ebv_read]{ebv_read()}})}

\item{outputpath}{Character. Set the path where you want to write the data to
disk as a GeoTiff. Ending needs to be *.tif.}

\item{epsg}{Integer. Default: 4326 (WGS84). Defines the coordinate reference
system via the corresponding epsg code.}

\item{extent}{Numeric. Default: c(-180,180,-90,90). Defines the extent of the
data: c(xmin, xmax, ymin, ymax).}

\item{type}{Character. Default is FLT8S Indicate the datatype of the GeoTiff
file. Possible values: INT1S, INT2S, INT2U, INT4S, INT4U, FLT4S, FLT8S.}

\item{overwrite}{Locigal. Default: FALSE. Set to TRUE to overwrite the
outputfile defined by 'outputpath'.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Returns the outputpath.
}
\description{
After you extracted data from the EBV netCDF and worked with it
this function gives you the possibility to write it to disk as a GeoTiff.
}
\note{
If the nodata value of your data is not detected correctly, this could
be due to the wrong choice of the datatype (type argument).
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_id1_20220208_v1.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)

\donttest{
#read data
data <- ebv_read(filepath = file, datacubepath = datacubes[1,1], timestep = 1, entity = 1)
# HERE YOU CAN WORK WITH YOUR DATA

#write data to disk as GeoTiff
out <- file.path(system.file(package='ebvcube'),"extdata","write_data.tif")
ebv_write(data = data, outputpath = out, overwrite = TRUE)

#read a subset
data_bb <- ebv_read_bb(filepath = file, datacubepath = datacubes[1,1],
                       entity = 1, timestep = 1:3, bb = c(5,15,47,55))

#write subset to disk as GeoTiff
ebv_write(data = data_bb, outputpath = out, extent = c(5,15,47,55), overwrite = TRUE)
}
}
