% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_and_leave_one_out.R
\name{boot_ebmstate}
\alias{boot_ebmstate}
\title{Bootstrap samples and bootstrap interval estimates}
\usage{
boot_ebmstate(
  mstate_data = NULL,
  which_group = NULL,
  min_nr_samples = NULL,
  patient_data = NULL,
  initial_state = NULL,
  tmat = NULL,
  time_model = NULL,
  backup_file = NULL,
  input_file = NULL,
  coxrfx_args = NULL,
  msfit_args = NULL,
  probtrans_args = NULL
)
}
\arguments{
\item{mstate_data}{A data frame with outcome and covariate data in long format.}

\item{which_group}{A character vector with the same meaning as the `groups` argument of the function \code{CoxRFX} but named (with the covariate names).}

\item{min_nr_samples}{The confidence interval of any coefficient is based on a number of bootstrap samples at least as high as this argument. See details.}

\item{patient_data}{The covariate data for which the estimates of cumulative hazards and transition probabilities are computed. 
Must contain: one row of data for each transition, all the covariate columns in the fitted model, and also the 'strata' column.}

\item{initial_state}{The initial state for which transition probability estimates should be computed}

\item{tmat}{Transition matrix for the multi-state model, as obtained by running \code{mstate::transMat}}

\item{time_model}{The model of time-dependency: either 'clockforward' or 'clockreset'.}

\item{backup_file}{Path to file. Objects generated while the present function is running are stored in this file. 
This avoids losing all estimates if and when the algorithm breaks down. See argument \code{input_file}.}

\item{input_file}{Path to \code{backup_file} (see argument \code{backup_file}). If this argument is given, all other arguments should be \code{NULL}.}

\item{coxrfx_args}{Named list with arguments to the \code{CoxRFX} function other than \code{Z},\code{surv} and \code{groups}.}

\item{msfit_args}{Named list with arguments to the \code{msfit_generic.coxrfx} function other than \code{object},\code{newdata} and \code{trans}.}

\item{probtrans_args}{Named list with arguments to the \code{probtrans_ebmstate} function other than \code{initia_state},\code{cumhaz} and \code{model}.}
}
\value{
A list with: 95\% bootstrap intervals for each regression coefficient and for transition probabilities; 
bootstrap samples of regression coefficients, cumulative hazards and transition probabilities.
}
\description{
This function computes bootstrap samples of regression coefficients,
cumulative hazard functions, and transition probability functions.
}
\details{
In a given bootstrap sample there might not be enough information to generate 
estimates for all coefficients. If a covariate has little or no variation in a given bootstrap sample, 
no estimate of its coefficient will be computed. The present function will
keep taking bootstrap samples until every coefficient has been estimated
at least \code{min_nr_samples} times. \code{covariate_df} should only contain the covariates
of the model one wishes to estimate.
}
\author{
Rui Costa
}
