% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample_grid}
\alias{sample_grid}
\alias{sample_case_control}
\title{Spatiotemporal sampling of points on a grid}
\usage{
sample_grid(x, res, t_res, n = 1, replace = FALSE, jitter = TRUE)

sample_case_control(x, res, t_res, n = 1, replace = FALSE, jitter = TRUE)
}
\arguments{
\item{x}{data frame or \link{sf} object; the points to subsample. If \code{x} is a data
frame the coordinates should be provided as columns \code{lat} and \code{lon}. The
day of year should be expressed as a proportion from 0-1 and stored in the
column \code{date}.}

\item{res}{numeric; the size in meters of the grid to sample from. This can
be a 2 element vector indicating the x and y dimensions of the cells.}

\item{t_res}{numeric; the temporal resolution for sampling expressed as a
proportion of the year. For example, \code{7 / 365} would result in sampling
from each week.}

\item{n}{integer; the number of points to sample from each grid cell.}

\item{replace}{logical; whether to sample with replacement.}

\item{jitter}{logical; to avoid always using the same grid for sampling, the
grid can be jittered so that the origin is different each time this
function is called.}
}
\value{
Logical vector indicating which rows are selected.
}
\description{
Subsample points to deal with spatiotemporal bias in observations by defining
a grid in space and time, then sampling the given number of points from each
cell. \code{\link[=sample_case_control]{sample_case_control()}} additionally samples presence and absence
independently.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# test data to sample
preds <- load_predictions(path, return_sf = TRUE)

# sample on a 250km, 4 month grid
s <- sample_grid(preds, res = 100000, t_res = 1 / 4)
preds_grid <- preds[s, ]

# case control sampling independently samples presence and absence
s <- sample_case_control(preds, res = 1000000, t_res = 1 / 12)
preds_cc <- preds[s, ]

# grid sampling preserves the presence/absence ratio
table(preds$obs > 0) / nrow(preds)
table(preds_grid$obs > 0) / nrow(preds_grid)
# while case control sampling increases the prevelance of presences
table(preds_cc$obs > 0) / nrow(preds_cc)

# plot
library(sf)
p <- par(mar = c(0, 0, 0, 0))
plot(st_geometry(preds), col = "black", pch = 19, cex = 0.2)
plot(st_geometry(preds_cc), col = "red", pch = 19, cex = 0.5, add = TRUE)
}
}
