% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-mapping.R
\name{map_centroids}
\alias{map_centroids}
\title{Map PI centroid locations}
\usage{
map_centroids(path, ext)
}
\arguments{
\item{path}{character; full path to directory containing the eBird Status and
Trends products for a single species.}

\item{ext}{\link{ebirdst_extent} object (optional); the spatiotemporal extent to
filter the data to.}
}
\value{
Plot showing locations of PI centroids.
}
\description{
Creates a map showing the stixel centroid locations for predictor importance
values, with an optional spatiotemporal subset using an \link{ebirdst_extent}
object
}
\examples{
\dontrun{
# download and load example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# define a spatiotemporal extent to plot
bb_vec <- c(xmin = -86, xmax = -83, ymin = 41.5, ymax = 43.5)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))

map_centroids(path = sp_path, ext = e)
}
}
