% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemUsageConstraint.R
\name{itemUsageConstraint}
\alias{itemUsageConstraint}
\title{Create item usage constraints.}
\usage{
itemUsageConstraint(
  nForms,
  nItems = NULL,
  formValues = rep(1, nForms),
  operator = c("<=", "=", ">="),
  targetValue = 1,
  whichItems = NULL,
  info_text = NULL,
  itemIDs = NULL
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool [optional to create \code{itemIDs} automatically].}

\item{formValues}{vector with values or weights for each form. Defaults to 1 for each form.}

\item{operator}{A character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{The value to be used in the constraints}

\item{whichItems}{A vector indicating which items should be constrained. Defaults to all the items.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Creates constraints related to item usage. That is, the number of times an item
is selected is constrained to be either (a) smaller or equal than
(\code{operator = "<="}), (b) equal to (\code{operator = "="}),
or (c) greater or equal than (\code{operator = ">="}) the chosen \code{value}.
}
\details{
When \code{operator = "<="} and \code{value = 1} (the default), each item can
be selected maximally once, which corresponds with assuring that there is no
item overlap between the forms. When \code{operator = "="} and \code{value = 1},
each item is used exactly once, which corresponds to no item-overlap and
complete item pool depletion.

If certain items are required in the resulting test form(s), as for example anchor items,
\code{whichItems} can be used to constrain the usage of these items to be exactly 1.
\code{whichItems} can either be a numeric vector with item numbers or a character vector
with item identifiers corresponding to \code{itemIDs}.
}
\examples{
## create no-item overlap constraints with item pool depletion
##  for 2 test forms with an item pool of 20 items
itemUsageConstraint(2, operator = "=", targetValue = 1,
                    itemIDs = 1:20)

## force certain items to be in the test, others not
usage1 <- itemUsageConstraint(2, operator = "<=", targetValue = 1,
                    itemIDs = paste0("item", 1:20))
usage2 <- itemUsageConstraint(2, operator = "=", targetValue = 1,
                    itemIDs = paste0("item", 1:20),
                    whichItems = c("item5", "item8", "item10"))

}
