% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontier.R
\name{frontier}
\alias{frontier}
\title{Efficiency Analysis Trees Frontier Graph}
\usage{
frontier(
  object,
  FDH = FALSE,
  observed.data = FALSE,
  observed.color = "black",
  pch = 19,
  size = 1,
  rwn = FALSE,
  max.overlaps = 10
)
}
\arguments{
\item{object}{An EAT object.}

\item{FDH}{Logical. If \code{TRUE}, FDH frontier is displayed.}

\item{observed.data}{Logical. If \code{TRUE}, observed DMUs are displayed.}

\item{observed.color}{String. Color for observed DMUs.}

\item{pch}{Integer. Point shape.}

\item{size}{Integer. Point size.}

\item{rwn}{Logical. If \code{TRUE}, rownames are displayed.}

\item{max.overlaps}{Exclude text labels that overlap too many things.}
}
\value{
Plot with estimated production frontier
}
\description{
This function displays a plot with the frontier estimated by Efficiency Analysis Trees in a scenario of one input and one output.
}
\examples{

simulated <- Y1.sim(N = 50, nX = 1)

model <- EAT(data = simulated,
             x = 1,
             y = 2)

frontier <- frontier(object = model,
                     FDH = TRUE, 
                     observed.data = TRUE,
                     rwn = TRUE)
plot(frontier)

}
