% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\alias{get_dec_table}
\alias{get_acs_table}
\title{Download data from a decennial census or ACS table}
\usage{
get_dec_table(
  geography,
  table,
  state = NULL,
  county = NULL,
  ...,
  drop_total = FALSE
)

get_acs_table(
  geography,
  table,
  year = 2019,
  state = NULL,
  county = NULL,
  survey = c("acs5", "acs1"),
  ...,
  drop_total = FALSE
)
}
\arguments{
\item{geography}{The geography level to download data for. Usually one of
\code{state}, \code{county}, \code{tract}, \verb{block group}, \code{block}, \code{zcta}, etc. Consult
\url{https://walker-data.com/tidycensus/articles/basic-usage.html#geography-in-tidycensus}
for more information.}

\item{table}{The table code to download. See \code{\link[=find_dec_table]{find_dec_table()}} for help
identifying a table of interest. Note: some tables are split into
A/B/C/etc. versions by race; this function unifies all of these tables
under one code. So, for example, use \code{P012}, not \code{P012A}.}

\item{state}{The state to get data for, if any.}

\item{county}{The state to get data for, if any.}

\item{...}{Further arguments passed to \code{\link[tidycensus:get_decennial]{tidycensus::get_decennial()}} or
\code{\link[tidycensus:get_acs]{tidycensus::get_acs()}}, e.g. \code{year}, \code{state}, \code{county}, \code{geometry}.}

\item{drop_total}{Whether to filter out variables which are totals across
another variable. Recommended only after inspection of the underlying
table.}

\item{year}{For ACS data, the survey year to get data for.}

\item{survey}{For ACS data, whether to use the one-year or
five-year survey (the default). Make sure to check availability using
\code{\link[=find_acs_table]{find_acs_table()}}.}
}
\value{
A tibble of census data in tidy format, with columns
\code{GEOID}, \code{NAME}, \code{variable} (containing the Census variable code),
\code{value} or \code{estiamte}, \code{moe} in the case of ACS tables,
and additional factor columns specific to the table.
}
\description{
Leverages \code{\link[tidycensus:get_decennial]{tidycensus::get_decennial()}} and \code{\link[tidycensus:get_acs]{tidycensus::get_acs()}} to
download tables of census data. Tables are returned in tidy format, with
variables given tidy, human-readable names.
}
\examples{
\dontrun{
get_dec_table("state", "P003")
get_dec_table("state", "H002")
get_dec_table("county", "H002", state="WA", drop_total=TRUE)

get_acs_table("county subdivision", "B09001", state="WA", county="King")
}

}
