% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyPubMed_scr.R
\name{articles_to_list}
\alias{articles_to_list}
\title{Cast PubMed Data into a List of Articles}
\usage{
articles_to_list(pubmed_data, encoding = "UTF8", simplify = TRUE)
}
\arguments{
\item{pubmed_data}{String corresponding to the name of an XML file (typically, 
the result of a batch_pubmed_download() call). Alternatively, a string including 
PubMed records with XML tags, such as the object returned by a fetch_pubmed_data() call.}

\item{encoding}{The encoding of an input/output connection can be specified by name 
(for example, "ASCII", or "UTF-8", in the same way as it would be given to the 
function base::iconv(). See iconv() help page for how to find out more about encodings 
that can be used on your platform. "UTF-8" is recommended.}

\item{simplify}{Logical; should the result be simplified to a character vector. 
If FALSE, results are returned as a list.}
}
\value{
List or character vector including all the records from the original XML object in text format. 
Elements in the list are not named and are only accessible via their numeric index.
}
\description{
Convert an XML object of PubMed records into a list of strings 
(character vector of length 1) corresponding to individual PubMed articles. 
PubMed records are identified by a "/PubmedArticle" XML tag. This automatically casts 
all the content of each PubMed record to a character-class object without removing XML tags.
}
\details{
The input is an XML object or a string including PubMed records (with XML tags). These are the
output of easyPubMed functions: fetch_pubmed_data() or batch_pubmed_download(). 
The function returns a list or a character vector where each element is a different PubMed record.
}
\examples{
try({
  ## Retrieve PubMed data and return a list ot articles
  my_query <- "Damiano Fantini[AU]"
  my_query <- get_pubmed_ids(pubmed_query_string = my_query)
  my_data <- fetch_pubmed_data(my_query, encoding = "ASCII")
  listed_articles <- articles_to_list(my_data)
  custom_grep(listed_articles[[2]], "ArticleTitle", "char")
}, silent = TRUE)

\dontrun{
## Download PubMed data and return a list ot articles
dami_query <- "Damiano Fantini[AU] AND 2018[PDAT]"
outfile <- batch_pubmed_download(dami_query, dest_file_prefix = "easyPM_ex001_")
listed_articles <- articles_to_list(pubmed_data = outfile)
custom_grep(listed_articles[[2]], "ArticleTitle", "char")
}

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
