% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{get_iers}
\alias{get_iers}
\title{get_iers}
\usage{
get_iers()
}
\value{
\code{data.frame} of earth orientation parameters with the following 
columns: datetime, ddt, ut1_utc, lod, x, y, dx, dy.
}
\description{
\code{get_iers} returns a \code{data.frame} of earth orientation 
parameters from (1962-present).  This function requires an active internet connection. 
Bulletins A and B are combined giving precedence to B. 
The following datasets are downloaded (~ 7 MB):
  \itemize{
    \item{\url{ftp://cddis.gsfc.nasa.gov/pub/products/iers/tai-utc.dat}}
    \item{\url{ftp://cddis.gsfc.nasa.gov/pub/products/iers/finals2000A.all}}
    \item{\url{ftp://cddis.gsfc.nasa.gov/pub/products/iers/finals2000A.daily}}
    \item{\url{http://hpiers.obspm.fr/iers/eop/eopc04/eopc04_IAU2000.62-now}}
  }
}
\examples{
\dontrun{
eop <- get_iers()
}

}
