% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_postpr.R
\name{abc_postpr}
\alias{abc_postpr}
\title{ABC model comparison wrapper}
\usage{
abc_postpr(sumstats = list(), target, ...)
}
\arguments{
\item{sumstats}{A named list of summary statistics matrices from different models.
Each element should be a matrix or data frame with the same columns.}

\item{target}{Target summary statistics from observed data (vector or matrix)}

\item{...}{Additional arguments passed to \code{\link[abc]{postpr}}}
}
\value{
An object of class "postpr" from \code{\link[abc]{postpr}}
}
\description{
Wrapper function for \code{\link[abc]{postpr}} to facilitate model comparison.
This function simplifies the process of comparing multiple models using ABC by
automatically stacking summary statistics and creating model indices.
}
\examples{
# Load pre-computed ABC input for model comparison
# This example compares the same model to itself for demonstration
rdm_minimal_example <- system.file("extdata", "rdm_minimal", package = "eam")
abc_input <- readRDS(file.path(rdm_minimal_example, "abc", "abc_input.rds"))

# Compare two models using their summary statistics
# In practice, create different abc_input objects for different models:
# abc_input_1 <- build_abc_input(..., simulation_summary = sim_summary_1, ...)
# abc_input_2 <- build_abc_input(..., simulation_summary = sim_summary_2, ...)
postpr_result <- abc_postpr(
  sumstats = list(model1 = abc_input$sumstat, model2 = abc_input$sumstat),
  target = abc_input$target,
  tol = 0.5,
  method = "rejection"
)

# View model comparison results
summary(postpr_result)
}
