% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifor.R
\name{ifor}
\alias{ifor}
\title{'for' Loop with Additional Features}
\usage{
ifor(ind, x, expr)
}
\arguments{
\item{ind}{variable name whose values are updated each round in the loop. Separate names with "." to allow for multiple variables}

\item{x}{sequence over which to loop}

\item{expr}{expression that is evaluated each round within the loop}
}
\value{
\code{NULL} invisibly
}
\description{
\code{ifor} evaluates an expression within a \code{for} loop, after applying
\code{\link{iter}} to the sequence. \code{ifor} also allows multiple indexes by
separating each variable name with a ".", such that \code{ifor(x, i.j, ...)}
is similar to \code{for (i,j in x) ...} if \code{for} loops accepted multiple
index values. See \code{\link{comprehension}} for more details. Assignment to
a variable outside of the function can be accomplished through \code{assign} or \code{<<-}.
}
\examples{
ifor(i.j, zip(1:4, 0:3),{
 print(i+j)
})

}
