% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_eLNNpaired.r
\name{gen_eLNNpaired}
\alias{gen_eLNNpaired}
\title{Generate a Simulated Data Set from eLNNpaired Model}
\description{
Generate a simulated data set from eLNNpaired model and store
it into an ExpressionSet object.
}
\usage{
gen_eLNNpaired(G, n, psi, t_pi, c1 = qnorm(0.95), c2 = qnorm(0.05))
}
\arguments{
\item{G}{An integer, the number of genes.}

\item{n}{An integer, the number of pairs for each gene.}

\item{psi}{A vector of length 10. It contains the parameters after reparameterization as illustrated in paper: 
\eqn{\delta_1}{delta_1}, 
\eqn{\xi_1}{xi_1}, \eqn{\lambda_1}{lambda_1}, \eqn{\nu_1}{nu_1}, 
\eqn{\delta_2}{delta_2}, 
\eqn{\xi_2}{xi_2}, \eqn{\lambda_2}{lambda_2}, \eqn{\nu_2}{nu_2}, 
\eqn{\lambda_3}{lambda_3}, and \eqn{\nu_3}{nu_3}. 
}

\item{t_pi}{the cluster proportion for cluster 1 (over-expressed probes)
and cluster 2 (under-expressed probes).}

\item{c1}{A parameter in constraints. It should be in the form of c1 = qnorm(X), where X is a decimal smaller than 1 but close to 1. Larger X gives more stringent constraint. Default value is \code{c1 = qnorm(0.95)}.}

\item{c2}{A parameter in constraints. It should be in the form of c2 = qnorm(Y), where Y is a decimal larger than 0 but close to 0. Smaller Y gives more stringent constraint. Default value is \code{c2 = qnorm(0.05)}.}
}
\value{
An ExpressionSet object, the feature data frame of which include
\code{memGenes.true} (3-cluster membership for gene probes)
and \code{memGenes2.true} (2-cluster membership for gene probes).

In 3-cluster membership, 1 indicates over-expressed,
2 indicates under-expressed, and 3 indicates non-differentially expressed.

In 2-cluster membership, 1 indicates differentially expressed,
0 indicates non-differentially expressed.

}
\author{
Yunfeng Li <colinlee1999@gmail.com> and Weiliang Qiu <stwxq@channing.harvard.edu>
}

\examples{
set.seed(100)
G = 500
n = 10

delta_1 = -0.8184384  
xi_1 = -1.1858546 
lambda_1 = -10.6309216  
nu_1 = -3.5536255  

delta_2 = -0.8153614  
xi_2 = -1.4120148 
lambda_2 = -13.1999427  
nu_2 = -3.3873531   

lambda_3 = 0.7597441  
nu_3 = -2.0361091 

psi = c(delta_1, xi_1, lambda_1, nu_1,
        delta_2, xi_2, lambda_2, nu_2,
        lambda_3, nu_3)
t_pi = c(0.08592752, 0.07110449)

c1 = qnorm(0.95)
c2 = qnorm(0.05)

E_Set = gen_eLNNpaired(G, n, psi, t_pi, c1, c2)


print(E_Set)

# phenotype data
pDat = pData(E_Set)
print(pDat[1:2,])

# feature data
fDat = fData(E_Set)
print(fDat[1:2,])

print(table(fDat$memGenes.true, useNA="ifany"))
print(table(fDat$memGenes2.true, useNA="ifany"))

print(table(fDat$memGenes.true, fDat$memGenes2.true, useNA="ifany"))

}
\keyword{ method }% use one of  RShowDoc("KEYWORDS")
\references{Li Y, Morrow J, Raby B, Tantisira K, Weiss ST, Huang W, Qiu W. (2017), <doi:10.1371/journal.pone.0174602>}
