% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_consist.R
\name{identify_inconsistency}
\alias{identify_inconsistency}
\title{Identify inconsistencies in a dataset}
\usage{
identify_inconsistency(data = NULL, consis_tbl = NULL, id_var = NULL)
}
\arguments{
\item{data}{data frame which will be checked for internal consistency}

\item{consis_tbl}{data frame or tibble containing information on internal
consistency rules (see "Consistency Table Requirements" section)}

\item{id_var}{An unquoted expression which corresponds to a variable in
\code{data} which identifies each row.}
}
\value{
tibble detailing any identified internal inconsistencies in
 \code{data}, if any are found. If no inconsistencies are found, \code{data}
 is returned invisibly.
}
\description{
Tests pairs of variables for consistency between their values according to
a table of rules or 'consistency table'.
}
\details{
Multiple types of checks for inconsistency are supported:
\enumerate{
\item Comparing by logical operators (<, <=, ==, !=, >=, >)
\item Comparing permitted categories (e.g. cat1 in varA only if cat2 in varB)
\item Comparing permitted numeric ranges (e.g. 20-25 in varC only if 10-20 in
varD)
\item Mixtures of 2 and 3 (e.g. cat1 in varA only if 20-25 in varC) 
}

The consistency tests rely on such rules being specified in a
separate data frame (\code{consis_tbl}; see section "Consistency Table Requirements").

Variable A is given higher priority than Variable B when A is a category. If A
(as char) is not equal to the value in col 4, the check is not made. This is
to account for one way dependencies (i.e. VarA is fruit, VarB is apple)
}
\section{Consistency Table Requirements}{
 Table must have exactly five character columns.
  The columns should be ordered according to the list below which describes the
  values of each column:
  \enumerate{
  \item First column name of data values that will be subject to 
  consistency checking. String. Required.
  \item Second column name of data values that will be subject to 
  consistency checking. String. Required.
  \item Logical test to compare columns one and two. One of: ">",">=",
  "<","<=","==", "!=". String. Optional if columns 4 and 5 have non-\code{NA} values.
  \item Either a single character string or a colon-separated range of
  numbers which should only appear in column A. Optional if column 3 has a
  non-\code{NA} value.
  \item Either a single character string or a colon-separated range of
  numbers which should only appear in column B given the value/range
  specified in column 4. Optional if column 3 has a non-\code{NA} value.
  }
  Each row should detail one test to make.
  Therefore, either column 3 or columns 4 and 5 must contain non-\code{NA}
  values.
}

\examples{
require(tibble)
# example with synthetic dataset on number of bean counts
# there is a lot going on in the function so a simple dataset aids this example
#
# creating `data`:
beans <- tibble::tibble(red_beans = 1:15,
blue_beans = 1:15,
total_beans = 1:15*2,
red_bean_summary = c(rep("few_beans",9), rep("many_beans",6)))
#
# creating `consis_tbl`
bean_rules <- tibble::tribble(~varA, ~varB, ~lgl_test, ~varA_boundaries, ~varB_boundaries,
"red_beans", "blue_beans", "==", NA, NA,
"red_beans", "total_beans", "<=", NA,NA,
"red_beans", "red_bean_summary", NA, "1:9", "few_beans",
"red_beans", "red_bean_summary", NA, "10:15", "many_beans")

identify_inconsistency(beans, bean_rules)

# creating some inconsistencies as examples
beans[1, "red_bean_summary"] <- "many_beans"
beans[1, "red_beans"] <- 10

identify_inconsistency(beans, bean_rules)

}
\seealso{
Other internal consistency functions: 
\code{\link{validate_consistency_tbl}()}
}
\concept{internal consistency functions}
