% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_distance.R
\name{calculate_distance}
\alias{calculate_distance}
\alias{correlation_distance}
\alias{manhattan_distance}
\alias{euclidean_distance}
\title{Distance metrics}
\usage{
calculate_distance(x, y = NULL, method = c("euclidean", "manhattan",
  "spearman", "pearson", "kendall"))

correlation_distance(x, y = NULL, method = c("pearson", "kendall",
  "spearman"), use = "everything")

manhattan_distance(x, y = NULL)

euclidean_distance(x, y = NULL)
}
\arguments{
\item{x}{A numeric matrix}

\item{y}{(Optional) a numeric matrix, with \code{ncol(x) == ncol(y)}.}

\item{method}{Distance method to use. Options are:
\itemize{
  \item euclidean: \code{\link{euclidean_distance}}
  \item manhattan: \code{\link{manhattan_distance}}
  \item spearman, pearson, or kendall: \code{\link{correlation_distance}}
}}

\item{use}{an optional character string giving a
    method for computing covariances in the presence
    of missing values.  This must be (an abbreviation of) one of the strings
    \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
    \code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}
}
\description{
Calculate (pairwise) distances between two matrices
}
\examples{
## Generate two matrices with 50 and 100 samples
x <- matrix(rnorm(50*10, mean = 0, sd = 1), ncol = 10)
y <- matrix(rnorm(100*10, mean = 1, sd = 2), ncol = 10)

dist_euclidean <- calculate_distance(x, y, method = "euclidean")
dist_manhattan <- calculate_distance(x, y, method = "manhattan")
dist_spearman <- calculate_distance(x, y, method = "spearman")
dist_pearson <- calculate_distance(x, y, method = "pearson")
dist_kendall <- calculate_distance(x, y, method = "kendall")
}
