% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_betas}
\alias{plot_betas}
\title{Plot Time-invariant Regression Coefficients of a Dynamite Model}
\usage{
plot_betas(
  x,
  parameters = NULL,
  responses = NULL,
  level = 0.05,
  include_alpha = TRUE
)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object}

\item{parameters}{[\code{charecter()}]\ Parameter name(s) for which the plots
should be drawn. Possible options can be found with function
\code{get_parameter_names(types = "beta")}.}

\item{responses}{[\code{character()}]\cr Response(s) for which the coefficients
should be drawn. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this whole vector.}

\item{level}{[\code{numeric(1)}]\cr Level for posterior intervals.
Default is 0.05, leading to 90\% intervals.}

\item{include_alpha}{[\code{logical(1)}]\cr If \code{TRUE} (default), plots also
the time-invariant alphas if such parameters exists in the model.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot Time-invariant Regression Coefficients of a Dynamite Model
}
\examples{
data.table::setDTthreads(1) # For CRAN
plot_betas(gaussian_example_fit, level = 0.1)

}
\seealso{
Drawing plots
\code{\link{plot.dynamitefit}()},
\code{\link{plot_deltas}()},
\code{\link{plot_lambdas}()},
\code{\link{plot_nus}()},
\code{\link{plot_psis}()}
}
\concept{plotting}
