/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import actions.ActionChangerAnnotations;
import actions.ActionChoixAxes;
import actions.ActionEnregistrer;
import actions.ActionExporter;
import actions.ActionFermer;
import actions.ActionGestionnaire;
import actions.ActionInternalClosed;
import actions.ActionLangue;
import actions.ActionOuvrir;
import don.DonneeParse;
import don.NullDonneeParse;
import drawing.Registre;
import exceptions.ExceptionIntegrite;
import ihm.FenetreErreur;
import ihm.FenetreHabillage;
import ihm.FenetreSelection;
import ihm.Gestionnaire;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.ui.RefineryUtilities;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel;
import org.jvnet.substance.theme.SubstanceSteelBlueTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import outils.Constantes;
import outils.Fichier;
import outils.XML;

public class IHM
extends JFrame {
    private static final long serialVersionUID = -783853601094190381L;
    public static String m_dir;
    private JMenuBar m_menu = null;
    private JMenu m_fichier = null;
    private JMenuItem m_ouvrir = null;
    private JMenuItem m_fermer;
    private JMenuItem m_enregistrer = null;
    private JMenuItem m_exporter;
    private JMenuItem m_imprimer = null;
    private JMenuItem m_langue = null;
    private JMenuItem m_quitter = null;
    private JMenu m_configuration = null;
    private JMenuItem m_axe = null;
    private JMenuItem m_typeGraphique = null;
    protected JRadioButtonMenuItem m_individus;
    private JRadioButtonMenuItem m_variables;
    private JRadioButtonMenuItem m_groupes;
    private JRadioButtonMenuItem m_axesPart;
    private JRadioButtonMenuItem m_dataframe;
    protected JCheckBoxMenuItem m_fantome;
    private JCheckBoxMenuItem m_partiels;
    protected JCheckBoxMenuItem m_grille;
    private JCheckBoxMenuItem m_annotations;
    private JMenu m_selection;
    private JMenuItem m_deselect = null;
    private JMenuItem m_inverser = null;
    private JMenuItem m_lstSelection = null;
    private JToolBar m_toolbar;
    private JSlider m_sliderAffinage = null;
    private JToolBar m_toolbarAffinage = null;
    private ImageIcon m_icoGrille;
    private JToggleButton m_btGrille;
    private ImageIcon m_icoDeselection;
    private JButton m_btDeselection;
    private ImageIcon m_icoInverserSelection;
    private JButton m_btInverserSelection;
    private ImageIcon m_icoSelectionParListe;
    private JButton m_btSelectionParListe;
    private ImageIcon m_icoAnnotation;
    private JToggleButton m_btAnnotation;
    public ImageIcon m_icoFantome;
    private JToggleButton m_btFantome;
    private ImageIcon m_icoPartiel;
    protected JToggleButton m_btPartiel;
    protected Gestionnaire m_gestionnaire;
    protected DonneeParse m_donneesParse;
    private ChartPanel m_chartPanel;
    private boolean m_goByR;
    private static XML m_xmlLangue;
    private XML m_xmlGeneral;
    private JCheckBoxMenuItem m_affLegende;
    private JMenuItem m_habillageFenetre;
    private JButton m_btHabillage;
    private ImageIcon m_icoHabillage;
    private JTabbedPane m_tabbedPane;
    protected int[] m_correspondance_tab_types;

    public IHM(DonneeParse donnees) {
        super("dynGraph");
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SubstanceOfficeSilver2007LookAndFeel());
            SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)new SubstanceSteelBlueTheme());
            SubstanceLookAndFeel.hideMenuSearchPanels();
            UIManager.put("substancelaf.noExtraElements", Boolean.TRUE);
        }
        catch (Exception ulafe) {
            System.out.println("Substance failed to set");
        }
        Image icone = Toolkit.getDefaultToolkit().getImage(String.valueOf(m_dir) + "ico/Rlogo-5.jpg");
        this.setIconImage(icone);
        this.gestionLangue();
        this.m_donneesParse = donnees;
        this.m_gestionnaire = new Gestionnaire(this);
    }

    public boolean getGoByR() {
        return this.m_goByR;
    }

    public DonneeParse getDonnee() {
        return this.m_donneesParse;
    }

    public void setDonneeParse(DonneeParse donnee) {
        this.m_donneesParse = donnee;
        this.redemarrer();
    }

    public void redemarrer() {
        this.m_menu = null;
        this.m_fichier = null;
        this.m_ouvrir = null;
        this.m_fermer = null;
        this.m_enregistrer = null;
        this.m_exporter = null;
        this.m_imprimer = null;
        this.m_langue = null;
        this.m_quitter = null;
        this.m_configuration = null;
        this.m_habillageFenetre = null;
        this.m_axe = null;
        this.m_typeGraphique = null;
        this.m_individus = null;
        this.m_variables = null;
        this.m_groupes = null;
        this.m_axesPart = null;
        this.m_dataframe = null;
        this.m_affLegende = null;
        this.m_fantome = null;
        this.m_partiels = null;
        this.m_grille = null;
        this.m_annotations = null;
        this.m_selection = null;
        this.m_deselect = null;
        this.m_inverser = null;
        this.m_lstSelection = null;
        this.m_toolbar = null;
        this.m_btGrille = null;
        this.m_btDeselection = null;
        this.m_btInverserSelection = null;
        this.m_btSelectionParListe = null;
        this.m_btHabillage = null;
        this.m_btAnnotation = null;
        this.m_btFantome = null;
        this.m_btPartiel = null;
        this.m_tabbedPane = null;
        this.m_toolbarAffinage = null;
        this.m_sliderAffinage = null;
        this.m_chartPanel = null;
        if (!(this.m_donneesParse instanceof NullDonneeParse)) {
            this.m_gestionnaire.prepareDonnees();
        }
        this.updateContenu();
    }

    public void demarrer() {
        if (!(this.m_donneesParse instanceof NullDonneeParse)) {
            this.m_gestionnaire.updateGraphe();
        }
        this.initialiser();
    }

    private void initialiser() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = graphicsEnvironment.getMaximumWindowBounds();
        this.setBounds(bounds);
        this.setExtendedState(this.getExtendedState() | 6);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                IHM.this.quitter();
            }
        });
        RefineryUtilities.centerFrameOnScreen(this);
        if (this.m_goByR) {
            this.setDefaultCloseOperation(0);
        }
        this.updateContenu();
    }

    public ChartPanel getChartPanel() {
        return this.m_chartPanel;
    }

    public DonneeParse getDonneeParse() {
        return this.m_donneesParse;
    }

    public void setChartPanel(ChartPanel chartPanel) {
        this.m_chartPanel = chartPanel;
    }

    public void setGoByR(boolean val) {
        this.m_goByR = val;
    }

    public Gestionnaire getGest() {
        return this.m_gestionnaire;
    }

    private boolean isDonneesChargees() {
        return !(this.m_donneesParse instanceof NullDonneeParse);
    }

    public void updateLang(int index) throws Exception {
        String nom = this.m_xmlGeneral.getElement("langue", index);
        this.m_xmlGeneral.setDefaut(this.m_xmlGeneral.searchByNom(nom));
        String path = String.valueOf(this.m_xmlGeneral.searchByNom(nom)) + ".xml";
        m_xmlLangue = new XML(String.valueOf(m_dir) + "langue" + File.separator + path);
        if (!(this.m_donneesParse instanceof NullDonneeParse)) {
            this.m_gestionnaire.sauverAnnotations();
            this.m_gestionnaire.updateGraphe();
        }
        this.redemarrer();
    }

    private void updateLangTextesDefaut() {
        UIManager.put("FileChooser.saveButtonText", IHM.getXmlLangue().getElement("Tenregistrer"));
        UIManager.put("FileChooser.openButtonText", IHM.getXmlLangue().getElement("Touvrir"));
        UIManager.put("FileChooser.cancelButtonText", IHM.getXmlLangue().getElement("Lannuler"));
        UIManager.put("FileChooser.updateButtonText", "");
        UIManager.put("FileChooser.helpButtonText", "");
        UIManager.put("FileChooser.saveButtonToolTipText", "");
    }

    private void gestionLangue() {
        this.m_xmlGeneral = new XML(String.valueOf(m_dir) + "langue" + File.separator + "langue.xml");
        String defaut = this.m_xmlGeneral.getDefaut();
        int max = this.m_xmlGeneral.getNbBalise("langue");
        int i = 0;
        boolean test = false;
        while (i < max && !test) {
            String chaine = this.m_xmlGeneral.getElement("id", i);
            if (defaut.compareTo(chaine) == 0) {
                m_xmlLangue = new XML(String.valueOf(m_dir) + "langue" + File.separator + chaine + ".xml");
                test = true;
            }
            ++i;
        }
    }

    private JSlider getSliderAffinage() {
        if (this.m_sliderAffinage == null) {
            int val = 0;
            double affinage = this.m_gestionnaire.getSeuilAffinage();
            if (affinage > 0.0) {
                val = (int)(affinage * 100.0);
            }
            this.m_sliderAffinage = new JSlider(0, 100, val);
            this.m_sliderAffinage.setOrientation(1);
            this.m_sliderAffinage.setAlignmentY(0.5f);
            this.m_sliderAffinage.setPaintTicks(true);
            this.m_sliderAffinage.setPaintLabels(true);
            this.m_sliderAffinage.setMajorTickSpacing(10);
            Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
            int i = 0;
            while (i <= 100) {
                table.put(i, new JLabel(String.valueOf((double)i / 100.0)));
                i += 10;
            }
            this.m_sliderAffinage.setLabelTable(table);
            this.m_sliderAffinage.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting() && IHM.this.m_gestionnaire.isAffinagePossible()) {
                        int val = source.getValue();
                        IHM.this.m_gestionnaire.setAffinage((double)val / 100.0);
                    }
                }
            });
        }
        if (!this.m_gestionnaire.isAffinagePossible()) {
            this.m_sliderAffinage.setValue(0);
            this.m_sliderAffinage.setEnabled(false);
        }
        return this.m_sliderAffinage;
    }

    private JToolBar getToolBarAffinage() {
        if (this.m_toolbarAffinage == null) {
            this.m_toolbarAffinage = new JToolBar();
            this.m_toolbarAffinage.setOrientation(1);
            JLabel label = new JLabel(IHM.getXmlLangue().getElement("LAffinageCos2"));
            label.setAlignmentX(0.5f);
            this.m_toolbarAffinage.add(label);
            this.m_toolbarAffinage.add(this.getSliderAffinage());
            this.m_toolbarAffinage.setFloatable(false);
        }
        return this.m_toolbarAffinage;
    }

    private JToolBar getToolbar() {
        if (this.m_toolbar == null) {
            this.m_toolbar = new JToolBar();
        }
        this.getBtGrid();
        this.getBtHabillage();
        this.m_toolbar.addSeparator();
        this.getBtDeselect();
        this.getBtInverserSelect();
        this.getBtSelectListe();
        this.m_toolbar.addSeparator();
        this.getBtAnnot();
        this.getBtFantome();
        this.getBtPartiel();
        this.m_toolbar.validate();
        this.m_toolbar.setFloatable(false);
        return this.m_toolbar;
    }

    private JButton getBtHabillage() {
        if (this.m_btHabillage == null) {
            this.m_icoHabillage = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_HABILLAGE);
            this.m_btHabillage = new JButton(this.m_icoHabillage);
            this.m_btHabillage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new FenetreHabillage((Frame)IHM.this, IHM.this.m_gestionnaire);
                }
            });
            this.m_toolbar.add(this.m_btHabillage);
        }
        this.m_btHabillage.setEnabled(this.isDonneesChargees() && this.m_gestionnaire.getHabilleur().isHabillagePossible(this.m_gestionnaire.getType()));
        this.m_btHabillage.setToolTipText(IHM.getXmlLangue().getElement("Mhabillage"));
        return this.m_btHabillage;
    }

    private JMenuBar getMenu() {
        if (this.m_menu == null) {
            this.m_menu = new JMenuBar();
        }
        return this.m_menu;
    }

    protected JToggleButton getBtAnnot() {
        if (this.m_btAnnotation == null) {
            this.m_icoAnnotation = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_ANNOTATIONS);
            this.m_btAnnotation = new JToggleButton(this.m_icoAnnotation);
            this.m_btAnnotation.addActionListener(new ActionChangerAnnotations(this.m_gestionnaire, this.m_btAnnotation));
            this.m_toolbar.add(this.m_btAnnotation);
        }
        this.m_btAnnotation.setEnabled(this.isActionAnnotPossible());
        this.m_btAnnotation.setSelected(this.m_gestionnaire.isAnnotationsDonnesEnCours());
        this.m_btAnnotation.setToolTipText(IHM.getXmlLangue().getElement("Mannotations"));
        return this.m_btAnnotation;
    }

    private boolean isActionAnnotPossible() {
        return this.isDonneesChargees() && !this.m_gestionnaire.isFantome(this.m_gestionnaire.getSelectionnes());
    }

    private JToggleButton getBtGrid() {
        if (this.m_btGrille == null) {
            this.m_icoGrille = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_GRID);
            this.m_btGrille = new JToggleButton(this.m_icoGrille);
            this.m_btGrille.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IHM.this.m_gestionnaire.setAffGrid(!IHM.this.m_gestionnaire.isAffGrid());
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_toolbar.add(this.m_btGrille);
        }
        this.m_btGrille.setSelected(this.m_gestionnaire.isAffGrid());
        this.m_btGrille.setEnabled(this.isDonneesChargees());
        this.m_btGrille.setToolTipText(IHM.getXmlLangue().getElement("Mgrid"));
        return this.m_btGrille;
    }

    private JButton getBtDeselect() {
        if (this.m_btDeselection == null) {
            this.m_icoDeselection = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_DESELECTION);
            this.m_btDeselection = new JButton(this.m_icoDeselection);
            this.m_btDeselection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IHM.this.m_gestionnaire.rmSelectionnes();
                }
            });
            this.m_toolbar.add(this.m_btDeselection);
        }
        this.m_btDeselection.setEnabled(this.isDonneesChargees());
        this.m_btDeselection.setToolTipText(IHM.getXmlLangue().getElement("Mdeselectionner"));
        return this.m_btDeselection;
    }

    private JButton getBtInverserSelect() {
        if (this.m_btInverserSelection == null) {
            this.m_icoInverserSelection = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_INVERSER);
            this.m_btInverserSelection = new JButton(this.m_icoInverserSelection);
            this.m_btInverserSelection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IHM.this.m_gestionnaire.inverserSelectionnes();
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_toolbar.add(this.m_btInverserSelection);
        }
        this.m_btInverserSelection.setEnabled(this.isDonneesChargees());
        this.m_btInverserSelection.setToolTipText(IHM.getXmlLangue().getElement("MinverserSelection"));
        return this.m_btSelectionParListe;
    }

    private JButton getBtSelectListe() {
        if (this.m_btSelectionParListe == null) {
            this.m_icoSelectionParListe = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_SELECTION_LISTE);
            this.m_btSelectionParListe = new JButton(this.m_icoSelectionParListe);
            this.m_btSelectionParListe.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new FenetreSelection(IHM.this, IHM.this.m_donneesParse, IHM.this.m_gestionnaire);
                }
            });
            this.m_toolbar.add(this.m_btSelectionParListe);
        }
        this.m_btSelectionParListe.setEnabled(this.isDonneesChargees());
        this.m_btSelectionParListe.setToolTipText(IHM.getXmlLangue().getElement("MselectListe"));
        return this.m_btSelectionParListe;
    }

    private JToggleButton getBtFantome() {
        if (this.m_btFantome == null) {
            this.m_icoFantome = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_FANTOME);
            this.m_btFantome = new JToggleButton(this.m_icoFantome);
            this.m_btFantome.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean nouvel_etat = !IHM.this.m_gestionnaire.isContientFantomeDonnesEnCours();
                    IHM.this.m_gestionnaire.setFantomeDonnesEnCours(nouvel_etat);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_toolbar.add(this.m_btFantome);
        }
        this.m_btFantome.setSelected(this.m_gestionnaire.isContientFantomeDonnesEnCours());
        this.m_btFantome.setEnabled(this.isDonneesChargees());
        this.m_btFantome.setToolTipText(IHM.getXmlLangue().getElement("Mfantome"));
        return this.m_btFantome;
    }

    private JToggleButton getBtPartiel() {
        if (this.m_btPartiel == null) {
            this.m_icoPartiel = new ImageIcon(String.valueOf(m_dir) + Constantes.ICONE_PARTIELS);
            this.m_btPartiel = new JToggleButton(this.m_icoPartiel);
            this.m_btPartiel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean nouvel_etat = !IHM.this.m_gestionnaire.isAffPartielsDonnesEnCours();
                    IHM.this.m_gestionnaire.setAffPartielsDonnesEnCours(nouvel_etat);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_toolbar.add(this.m_btPartiel);
        }
        this.m_btPartiel.setEnabled(this.isActionPartielPossible());
        this.m_btPartiel.setSelected(this.m_gestionnaire.isAffPartielsDonnesEnCours());
        this.m_btPartiel.setToolTipText(IHM.getXmlLangue().getElement("MPartiels"));
        return this.m_btPartiel;
    }

    private boolean isActionPartielPossible() {
        return !this.m_gestionnaire.isFantome(this.m_gestionnaire.getSelectionnes()) && this.m_donneesParse.isIndPart() && this.m_gestionnaire.getType() == 0 || this.m_donneesParse.isVarPart() && this.m_gestionnaire.getType() == 1;
    }

    private JMenu getFichier() {
        if (this.m_fichier == null) {
            this.m_fichier = new JMenu();
        }
        this.m_fichier.setText(IHM.getXmlLangue().getElement("Mfichier"));
        this.getOuvrir();
        this.getFermer();
        this.getEnregistrer();
        this.getExporter();
        this.getPrint();
        this.getLang();
        this.getQuitter();
        return this.m_fichier;
    }

    private JMenuItem getLang() {
        if (this.m_langue == null) {
            this.m_langue = new JMenu();
            ButtonGroup types = new ButtonGroup();
            String langueDefaut = this.m_xmlGeneral.getLangueDefaut();
            int i = 0;
            while (i < this.m_xmlGeneral.getNbBalise("langue")) {
                String langueItem = this.m_xmlGeneral.getElement("langue", i);
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(langueItem);
                item.addActionListener(new ActionLangue(this, i));
                types.add(item);
                this.m_langue.add(item);
                if (langueItem.equals(langueDefaut)) {
                    item.setSelected(true);
                }
                ++i;
            }
            this.m_fichier.add(this.m_langue);
        }
        this.m_langue.setText(IHM.getXmlLangue().getElement("Mlang"));
        return this.m_langue;
    }

    private JMenuItem getOuvrir() {
        if (this.m_ouvrir == null) {
            this.m_ouvrir = new JMenuItem();
            this.m_ouvrir.addActionListener(new ActionOuvrir(this.m_gestionnaire));
            this.m_fichier.add(this.m_ouvrir);
        }
        this.m_ouvrir.setText(IHM.getXmlLangue().getElement("Mouvrir"));
        return this.m_ouvrir;
    }

    private JMenuItem getFermer() {
        if (this.m_fermer == null) {
            this.m_fermer = new JMenuItem();
            this.m_fermer.addActionListener(new ActionInternalClosed(this.m_gestionnaire));
            this.m_fichier.add(this.m_fermer);
        }
        this.m_fermer.setEnabled(!(this.m_donneesParse instanceof NullDonneeParse));
        this.m_fermer.setText(IHM.getXmlLangue().getElement("Mfermer"));
        return this.m_ouvrir;
    }

    private JMenuItem getEnregistrer() {
        if (this.m_enregistrer == null) {
            this.m_enregistrer = new JMenuItem();
            this.m_enregistrer.addActionListener(new ActionEnregistrer(this.m_gestionnaire));
            this.m_fichier.add(this.m_enregistrer);
        }
        this.m_enregistrer.setEnabled(!(this.m_donneesParse instanceof NullDonneeParse));
        this.m_enregistrer.setText(IHM.getXmlLangue().getElement("Menregistrer"));
        return this.m_enregistrer;
    }

    private JMenuItem getPrint() {
        if (this.m_imprimer == null) {
            this.m_imprimer = new JMenuItem();
            this.m_imprimer.addActionListener(new ActionGestionnaire(this.m_gestionnaire){

                public void actionPerformed(ActionEvent e) {
                    this.m_gest.getPanel().createChartPrintJob();
                }
            });
            this.m_fichier.add(this.m_imprimer);
        }
        this.m_imprimer.setEnabled(!(this.m_donneesParse instanceof NullDonneeParse));
        this.m_imprimer.setText(IHM.getXmlLangue().getElement("Print..."));
        return this.m_imprimer;
    }

    private JMenuItem getExporter() {
        if (this.m_exporter == null) {
            this.m_exporter = new JMenuItem();
            this.m_exporter.addActionListener(new ActionExporter(this.m_gestionnaire));
            this.m_fichier.add(this.m_exporter);
        }
        this.m_exporter.setEnabled(this.isDonneesChargees());
        this.m_exporter.setText(IHM.getXmlLangue().getElement("Mexporter..."));
        return this.m_exporter;
    }

    private JMenuItem getQuitter() {
        if (this.m_quitter == null) {
            this.m_quitter = new JMenuItem();
            this.m_quitter.addActionListener(new ActionFermer(this));
            this.m_fichier.add(this.m_quitter);
            this.m_menu.add(this.m_fichier);
        }
        this.m_quitter.setText(IHM.getXmlLangue().getElement("Mquitter"));
        return this.m_quitter;
    }

    private JMenu getConfig() {
        boolean construction;
        boolean bl = construction = this.m_configuration == null;
        if (construction) {
            this.m_configuration = new JMenu();
            this.m_menu.add(this.m_configuration);
        }
        this.m_configuration.setText(IHM.getXmlLangue().getElement("Mgraphe"));
        if (this.isDonneesChargees()) {
            this.m_configuration.setEnabled(true);
            this.getAxe();
            this.getTypeGr();
            if (construction) {
                this.m_configuration.addSeparator();
            }
            this.getHabillageFenetre();
            this.getAfficherLegende();
            this.getGrille();
            if (construction) {
                this.m_configuration.addSeparator();
            }
            this.getAnnot();
            this.getFantome();
            this.getPartiels();
        } else {
            this.m_configuration.setEnabled(false);
        }
        return this.m_configuration;
    }

    private JMenuItem getHabillageFenetre() {
        if (this.m_habillageFenetre == null) {
            this.m_habillageFenetre = new JMenuItem(String.valueOf(IHM.getXmlLangue().getElement("Mhabillage")) + "...");
            this.m_habillageFenetre.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new FenetreHabillage((Frame)IHM.this, IHM.this.m_gestionnaire);
                }
            });
            this.m_habillageFenetre.setEnabled(this.isDonneesChargees() && this.m_gestionnaire.getHabilleur().isHabillagePossible(this.m_gestionnaire.getType()));
            this.m_configuration.add(this.m_habillageFenetre);
        }
        return this.m_habillageFenetre;
    }

    private JMenuItem getTypeGr() {
        if (this.m_typeGraphique == null) {
            this.m_typeGraphique = new JMenu();
            this.m_configuration.add(this.m_typeGraphique);
        }
        int nbRepPossibles = 0;
        if (this.m_donneesParse.getGroupes().size() > 1) {
            ++nbRepPossibles;
        }
        if (this.m_donneesParse.getIndividusMoyens().size() > 0) {
            ++nbRepPossibles;
        }
        if (this.m_donneesParse.getVariablesMoyennes().size() > 0) {
            ++nbRepPossibles;
        }
        if (this.m_donneesParse.getType() == DonneeParse.TypeAnalyse.DATAFRAME) {
            nbRepPossibles = 0;
        }
        if (nbRepPossibles > 1) {
            this.m_typeGraphique.setEnabled(true);
        } else {
            this.m_typeGraphique.setEnabled(false);
        }
        ButtonGroup types = new ButtonGroup();
        types.add(this.getIndividus());
        if (this.m_donneesParse.getVariablesMoyennes().size() > 0) {
            types.add(this.getVariables());
        }
        if (this.m_donneesParse.getGroupes().size() > 1) {
            types.add(this.getGroupes());
        }
        if (this.m_donneesParse.isAxesPart()) {
            types.add(this.getAxesPart());
        }
        if (this.m_donneesParse.isRepDataframePossible()) {
            types.add(this.getDataframe());
        }
        if (this.m_gestionnaire.getType() == 0) {
            this.m_individus.setSelected(true);
        } else if (this.m_gestionnaire.getType() == 1) {
            this.m_variables.setSelected(true);
        } else if (this.m_gestionnaire.getType() == 2) {
            this.m_groupes.setSelected(true);
        } else if (this.m_gestionnaire.getType() == 3) {
            this.m_axesPart.setSelected(true);
        } else if (this.m_gestionnaire.getType() == 4) {
            this.m_dataframe.setSelected(true);
        }
        this.m_typeGraphique.setText(IHM.getXmlLangue().getElement("MtypeGR"));
        return this.m_typeGraphique;
    }

    private JRadioButtonMenuItem getIndividus() {
        if (this.m_individus == null) {
            this.m_individus = new JRadioButtonMenuItem();
            this.m_individus.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    IHM.this.m_gestionnaire.setType(0);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_typeGraphique.add(this.m_individus);
        }
        this.m_individus.setSelected(this.m_gestionnaire.getType() == 0);
        this.m_individus.setText(IHM.getXmlLangue().getElement("MtypeGRInd"));
        return this.m_individus;
    }

    private JRadioButtonMenuItem getVariables() {
        if (this.m_variables == null) {
            this.m_variables = new JRadioButtonMenuItem();
            this.m_variables.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    IHM.this.m_gestionnaire.setType(1);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_typeGraphique.add(this.m_variables);
        }
        this.m_variables.setSelected(this.m_gestionnaire.getType() == 1);
        this.m_variables.setText(IHM.getXmlLangue().getElement("MtypeGRVar"));
        return this.m_variables;
    }

    private JRadioButtonMenuItem getGroupes() {
        if (this.m_groupes == null) {
            this.m_groupes = new JRadioButtonMenuItem();
            this.m_groupes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    IHM.this.m_gestionnaire.setType(2);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_typeGraphique.add(this.m_groupes);
        }
        this.m_groupes.setSelected(this.m_gestionnaire.getType() == 2);
        this.m_groupes.setText(IHM.getXmlLangue().getElement("MtypeGRGr"));
        return this.m_groupes;
    }

    private JRadioButtonMenuItem getAxesPart() {
        if (this.m_axesPart == null) {
            this.m_axesPart = new JRadioButtonMenuItem();
            this.m_axesPart.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    IHM.this.m_gestionnaire.setType(3);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_typeGraphique.add(this.m_axesPart);
        }
        this.m_axesPart.setSelected(this.m_gestionnaire.getType() == 3);
        this.m_axesPart.setText(IHM.getXmlLangue().getElement("MtypeGRAxesPart"));
        return this.m_axesPart;
    }

    private AbstractButton getDataframe() {
        if (this.m_dataframe == null) {
            this.m_dataframe = new JRadioButtonMenuItem();
            this.m_dataframe.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    IHM.this.m_gestionnaire.setType(4);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_typeGraphique.add(this.m_dataframe);
        }
        this.m_dataframe.setSelected(this.m_gestionnaire.getType() == 4);
        this.m_dataframe.setText(IHM.getXmlLangue().getElement("MtypeGRAxesDataframe"));
        return this.m_dataframe;
    }

    private JMenuItem getAxe() {
        if (this.m_donneesParse.getNbAxe() > 2 || this.m_gestionnaire.getType() == 4) {
            if (this.m_axe == null) {
                this.m_axe = new JMenuItem();
                this.m_axe.addActionListener(new ActionChoixAxes(this, this.m_donneesParse.getNbAxe(), this.m_donneesParse.getInerties(), this.m_gestionnaire));
                this.m_configuration.add(this.m_axe);
            }
            this.m_axe.setEnabled(true);
            this.m_axe.setText(IHM.getXmlLangue().getElement("Maxe"));
        } else {
            this.m_axe = null;
        }
        return this.m_axe;
    }

    private JCheckBoxMenuItem getAfficherLegende() {
        if (this.m_affLegende == null) {
            this.m_affLegende = new JCheckBoxMenuItem();
            this.m_affLegende.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    IHM.this.m_gestionnaire.setAffLegende(!IHM.this.m_gestionnaire.isAffLegende());
                }
            });
            this.m_configuration.add(this.m_affLegende);
        }
        this.m_affLegende.setText(IHM.getXmlLangue().getElement("Mlegende"));
        this.m_affLegende.setSelected(this.m_gestionnaire.isAffLegende());
        return this.m_affLegende;
    }

    protected JCheckBoxMenuItem getPartiels() {
        if (this.m_partiels == null) {
            this.m_partiels = new JCheckBoxMenuItem();
            this.m_partiels.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    boolean nouvel_etat = !IHM.this.m_gestionnaire.isAffPartielsDonnesEnCours();
                    IHM.this.m_gestionnaire.setAffPartielsDonnesEnCours(nouvel_etat);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_configuration.add(this.m_partiels);
        }
        this.m_partiels.setText(IHM.getXmlLangue().getElement("MPartiels"));
        this.m_partiels.setEnabled(this.isActionPartielPossible());
        this.m_partiels.setSelected(this.m_gestionnaire.isAffPartielsDonnesEnCours());
        return this.m_partiels;
    }

    private JCheckBoxMenuItem getFantome() {
        if (this.m_fantome == null) {
            this.m_fantome = new JCheckBoxMenuItem();
            this.m_fantome.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean nouvel_etat = !IHM.this.m_gestionnaire.isContientFantomeDonnesEnCours();
                    IHM.this.m_gestionnaire.setFantomeDonnesEnCours(nouvel_etat);
                    IHM.this.updateMenuBarre();
                }
            });
            this.m_configuration.add(this.m_fantome);
        }
        this.m_fantome.setSelected(this.m_gestionnaire.isContientFantomeDonnesEnCours());
        this.m_fantome.setText(IHM.getXmlLangue().getElement("Mfantome"));
        this.m_fantome.setEnabled(this.isDonneesChargees());
        return this.m_fantome;
    }

    private JCheckBoxMenuItem getGrille() {
        if (this.isDonneesChargees()) {
            if (this.m_grille == null) {
                this.m_grille = new JCheckBoxMenuItem();
                this.m_grille.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        IHM.this.m_gestionnaire.setAffGrid(!IHM.this.m_gestionnaire.isAffGrid());
                        IHM.this.updateMenuBarre();
                    }
                });
                this.m_configuration.add(this.m_grille);
            }
            this.m_grille.setSelected(this.m_gestionnaire.isAffGrid());
            this.m_grille.setEnabled(this.m_gestionnaire.getType() != 2);
            this.m_grille.setText(IHM.getXmlLangue().getElement("Mgrid"));
        }
        return this.m_grille;
    }

    private JCheckBoxMenuItem getAnnot() {
        if (this.isDonneesChargees()) {
            if (this.m_annotations == null) {
                this.m_annotations = new JCheckBoxMenuItem();
                this.m_annotations.addActionListener(new ActionChangerAnnotations(this.m_gestionnaire, this.m_annotations));
                this.m_configuration.add(this.m_annotations);
            }
            this.m_annotations.setEnabled(this.isActionAnnotPossible());
            this.m_annotations.setSelected(this.m_gestionnaire.isAnnotationsDonnesEnCours());
            this.m_annotations.setText(IHM.getXmlLangue().getElement("Mannotations"));
        }
        return this.m_annotations;
    }

    private JMenuItem getDeselect() {
        if (this.isDonneesChargees()) {
            if (this.m_deselect == null) {
                this.m_deselect = new JMenuItem();
                this.m_deselect.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        IHM.this.m_gestionnaire.rmSelectionnes();
                    }
                });
                this.m_selection.add(this.m_deselect);
            }
            this.m_deselect.setText(IHM.getXmlLangue().getElement("Mdeselectionner"));
        }
        return this.m_deselect;
    }

    private JMenuItem getInverser() {
        if (this.isDonneesChargees()) {
            if (this.m_inverser == null) {
                this.m_inverser = new JMenuItem();
                this.m_inverser.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        IHM.this.getBtAnnot().setEnabled(true);
                        if (IHM.this.m_gestionnaire.getType() != 0) {
                            IHM.this.m_btPartiel.setEnabled(false);
                        } else {
                            IHM.this.m_btPartiel.setEnabled(true);
                        }
                        IHM.this.m_gestionnaire.inverserSelectionnes();
                    }
                });
                this.m_selection.add(this.m_inverser);
            }
            this.m_inverser.setText(IHM.getXmlLangue().getElement("MinverserSelection"));
        }
        return this.m_inverser;
    }

    private JMenuItem getSelectParListe() {
        if (this.isDonneesChargees()) {
            if (this.m_lstSelection == null) {
                this.m_lstSelection = new JMenuItem();
                this.m_lstSelection.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new FenetreSelection(IHM.this, IHM.this.m_donneesParse, IHM.this.m_gestionnaire);
                    }
                });
                this.m_selection.add(this.m_lstSelection);
            }
            this.m_lstSelection.setText(String.valueOf(IHM.getXmlLangue().getElement("MselectListe")) + "...");
        }
        return this.m_lstSelection;
    }

    private JMenu getSelection() {
        if (this.m_selection == null) {
            this.m_selection = new JMenu();
            this.m_menu.add(this.m_selection);
        }
        this.m_selection.setText(IHM.getXmlLangue().getElement("Tselect"));
        if (this.isDonneesChargees()) {
            this.m_selection.setEnabled(true);
            this.getDeselect();
            this.getInverser();
            this.getSelectParListe();
        } else {
            this.m_selection.setEnabled(false);
        }
        return this.m_selection;
    }

    public JMenuBar updateMenuBarre() {
        this.getMenu();
        this.getFichier();
        this.getConfig();
        this.getSelection();
        this.getToolbar();
        this.getToolBarAffinage();
        return this.m_menu;
    }

    private void updateContenu() {
        int w = 0;
        int h = 0;
        w = this.getWidth() - 100;
        h = this.getHeight() - 100;
        this.setContentPane(this.getContenu());
        if (!(this.m_donneesParse instanceof NullDonneeParse)) {
            this.getChartPanel().setMaximumDrawWidth(w);
            this.getChartPanel().setMaximumDrawHeight(h - this.m_toolbar.getHeight() - this.m_menu.getHeight());
        }
        this.setVisible(true);
    }

    private JPanel getContenu() {
        this.setJMenuBar(this.updateMenuBarre());
        this.updateLangTextesDefaut();
        JPanel contenu = new JPanel();
        contenu.setLayout(new BorderLayout());
        if (!(this.m_donneesParse instanceof NullDonneeParse)) {
            this.m_gestionnaire.updateGraphe();
            this.m_tabbedPane = this.getJTabbedPane();
            contenu.add((Component)this.m_tabbedPane, "Center");
        }
        contenu.add((Component)this.m_toolbar, "North");
        contenu.add((Component)this.m_toolbarAffinage, "West");
        return contenu;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.m_tabbedPane == null) {
            this.m_tabbedPane = new JTabbedPane();
            this.m_correspondance_tab_types = new int[5];
            int i = 0;
            if (this.m_donneesParse.getType() != DonneeParse.TypeAnalyse.DATAFRAME) {
                JPanel panelInd = new JPanel();
                this.m_tabbedPane.addTab(IHM.getXmlLangue().getElement("MtypeGRInd"), panelInd);
                this.m_correspondance_tab_types[i] = 0;
                ++i;
                if (this.m_donneesParse.getVariablesMoyennes().size() > 0) {
                    JPanel panelVar = new JPanel();
                    this.m_tabbedPane.addTab(IHM.getXmlLangue().getElement("MtypeGRVar"), panelVar);
                    this.m_correspondance_tab_types[i] = 1;
                    ++i;
                }
                if (this.m_donneesParse.getGroupes().size() > 1) {
                    JPanel panelGr = new JPanel();
                    this.m_tabbedPane.addTab(IHM.getXmlLangue().getElement("MtypeGRGr"), panelGr);
                    this.m_correspondance_tab_types[i] = 2;
                    ++i;
                }
                if (this.m_donneesParse.isAxesPart()) {
                    JPanel panelAxes = new JPanel();
                    this.m_tabbedPane.addTab(IHM.getXmlLangue().getElement("MtypeGRAxesPart"), panelAxes);
                    this.m_correspondance_tab_types[i] = 3;
                    ++i;
                }
            }
            if (this.m_donneesParse.isRepDataframePossible()) {
                JPanel panelDataframe = new JPanel();
                this.m_tabbedPane.addTab(IHM.getXmlLangue().getElement("MtypeGRAxesDataframe"), panelDataframe);
                this.m_correspondance_tab_types[i] = 4;
                ++i;
            }
            int index = -1;
            int j = 0;
            while (j < this.m_correspondance_tab_types.length && index == -1) {
                if (this.m_gestionnaire.getType() == this.m_correspondance_tab_types[j]) {
                    index = j;
                }
                ++j;
            }
            this.m_tabbedPane.setComponentAt(index, this.m_chartPanel);
            this.m_tabbedPane.setSelectedIndex(index);
            this.m_tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int index = ((JTabbedPane)e.getSource()).getSelectedIndex();
                    if (index >= 0) {
                        IHM.this.m_gestionnaire.setType(IHM.this.m_correspondance_tab_types[index]);
                    }
                }
            });
        }
        return this.m_tabbedPane;
    }

    public Point getDecGraphe() {
        if (this.m_toolbar != null) {
            Rectangle b = this.getChartPanel().getBounds();
            return b.getLocation();
        }
        return new Point(0, 0);
    }

    public void quitter() {
        if (this.getTitle().equals("dynGraph")) {
            this.dispose();
            new RuntimeException("exit");
        }
        if (!this.m_goByR) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            DonneeParse donnees;
            String dir = args.length < 1 ? String.valueOf(new File("").getAbsolutePath()) + File.separator : args[0];
            m_dir = dir;
            String fichier = args.length < 2 ? null : args[1];
            if (fichier != null) {
                Registre reg = Fichier.chargerDonnees(fichier);
                donnees = reg.getDonnee();
                try {
                    donnees.verifierIntegrite();
                }
                catch (ExceptionIntegrite e) {
                    new FenetreErreur(e);
                }
                if (args.length == 3 && args[2].equals("-t")) {
                    File f = new File(fichier);
                    f.delete();
                }
            } else {
                donnees = new NullDonneeParse();
            }
            IHM ihm = new IHM(donnees);
            ihm.m_goByR = false;
            ihm.demarrer();
        }
        catch (Exception e) {
            new FenetreErreur(e);
        }
    }

    public static XML getXmlLangue() {
        if (m_xmlLangue == null) {
            XML xmlGeneral = new XML(String.valueOf(m_dir) + "langue" + File.separator + "langue.xml");
            String defaut = xmlGeneral.getDefaut();
            int max = xmlGeneral.getNbBalise("langue");
            int i = 0;
            boolean test = false;
            while (i < max && !test) {
                String chaine = xmlGeneral.getElement("id", i);
                if (defaut.compareTo(chaine) == 0) {
                    m_xmlLangue = new XML(String.valueOf(m_dir) + "langue" + File.separator + chaine + ".xml");
                    test = true;
                }
                ++i;
            }
        }
        return m_xmlLangue;
    }
}

