/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.BaseGradientPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class StandardGradientPainter
extends BaseGradientPainter {
    public String getDisplayName() {
        return "Standard";
    }

    public BufferedImage getContourBackground(int width, int height, Shape contour, boolean isFocused, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        BufferedImage mixResult = this.getMixContourBackground(width, height, contour, isFocused, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        if (mixResult != null) {
            return mixResult;
        }
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme interpolationScheme1 = colorScheme1;
        ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topBorderColor = this.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midBorderColor = this.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomBorderColor = this.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color topFillColor = this.getTopFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midFillColorTop = this.getMidFillColorTop(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midFillColorBottom = this.getMidFillColorBottom(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomFillColor = this.getBottomFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color topShineColor = this.getTopShineColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomShineColor = this.getBottomShineColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.setClip(contour);
        GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, topFillColor, 0.0f, height / 2, midFillColorTop);
        graphics.setPaint(gradientTop);
        graphics.fillRect(0, 0, width, height / 2);
        GradientPaint gradientBottom = new GradientPaint(0.0f, height / 2, midFillColorBottom, 0.0f, height - 2, bottomFillColor);
        graphics.setPaint(gradientBottom);
        graphics.fillRect(0, height / 2, width, height / 2);
        if (hasShine && topShineColor != null && bottomShineColor != null) {
            int shineHeight = (int)((double)height / 1.8);
            int kernelSize = (int)Math.min(12.0, Math.pow(Math.min(width, height), 0.8) / 4.0);
            if (kernelSize < 3) {
                kernelSize = 3;
            }
            BufferedImage blurredGhostContour = SubstanceCoreUtilities.getBlankImage(width + 2 * kernelSize, height + 2 * kernelSize);
            Graphics2D blurredGhostGraphics = (Graphics2D)blurredGhostContour.getGraphics().create();
            blurredGhostGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            blurredGhostGraphics.setColor(Color.black);
            blurredGhostGraphics.translate(kernelSize, kernelSize);
            int step = kernelSize > 5 ? 2 : 1;
            for (int strokeSize = 2 * kernelSize - 1; strokeSize > 0; strokeSize -= step) {
                float transp = 1.0f - (float)strokeSize / (2.0f * (float)kernelSize);
                blurredGhostGraphics.setComposite(AlphaComposite.getInstance(2, transp));
                blurredGhostGraphics.setStroke(new BasicStroke(strokeSize));
                blurredGhostGraphics.draw(contour);
            }
            blurredGhostGraphics.dispose();
            BufferedImage reverseGhostContour = SubstanceCoreUtilities.getBlankImage(width + 2 * kernelSize, height + 2 * kernelSize);
            Graphics2D reverseGraphics = (Graphics2D)reverseGhostContour.getGraphics();
            Color bottomShineColorTransp = new Color(bottomShineColor.getRed(), bottomShineColor.getGreen(), bottomShineColor.getBlue(), 64);
            GradientPaint gradientShine = new GradientPaint(0.0f, kernelSize, topShineColor, 0.0f, kernelSize + shineHeight, bottomShineColorTransp);
            reverseGraphics.setPaint(gradientShine);
            reverseGraphics.fillRect(0, kernelSize, width + 2 * kernelSize, kernelSize + shineHeight);
            reverseGraphics.setComposite(AlphaComposite.DstOut);
            reverseGraphics.drawImage((Image)blurredGhostContour, 0, 0, null);
            graphics.drawImage(reverseGhostContour, 0, 0, width - 1, shineHeight, kernelSize, kernelSize, kernelSize + width - 1, kernelSize + shineHeight, null);
            BufferedImage overGhostContour = SubstanceCoreUtilities.getBlankImage(width + 2 * kernelSize, height + 2 * kernelSize);
            Graphics2D overGraphics = (Graphics2D)overGhostContour.getGraphics();
            overGraphics.setPaint(new GradientPaint(0.0f, kernelSize, topFillColor, 0.0f, kernelSize + height / 2, midFillColorTop));
            overGraphics.fillRect(kernelSize, kernelSize, kernelSize + width, kernelSize + shineHeight);
            overGraphics.setComposite(AlphaComposite.DstIn);
            overGraphics.drawImage((Image)blurredGhostContour, 0, 0, null);
            graphics.drawImage(overGhostContour, 0, 0, width - 1, shineHeight, kernelSize, kernelSize, kernelSize + width - 1, kernelSize + shineHeight, null);
        }
        if (topBorderColor != null && midBorderColor != null) {
            GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradientBorderTop);
            graphics.setClip(0, 0, width, height / 2);
            graphics.draw(contour);
        }
        if (bottomBorderColor != null && midBorderColor != null) {
            GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradientBorderBottom);
            graphics.setClip(0, height / 2, width, 1 + height / 2);
            graphics.draw(contour);
        }
        return image;
    }

    public Color getTopBorderColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getMidBorderColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getBottomBorderColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getTopFillColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getTopFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public Color getMidFillColorTop(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getMidFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public Color getMidFillColorBottom(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return this.getMidFillColorTop(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public Color getBottomFillColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public Color getTopShineColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getTopShineColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public Color getBottomShineColor(ColorScheme interpolationScheme1, ColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomShineColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
    }
}

