% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapeVarCross.R
\name{scrapeVarCross}
\alias{scrapeVarCross}
\title{A Variable Name-Scraping and Indexing Function for cross-sectional data}
\usage{
scrapeVarCross(
  dat,
  x_order = "spi",
  x_stem,
  x_delim1 = NULL,
  x_delim2 = NULL,
  x_item_num = "\\\\d+",
  distinguish_1 = "1",
  distinguish_2 = "2",
  y_order = NULL,
  y_stem = NULL,
  y_delim1 = NULL,
  y_delim2 = NULL,
  y_item_num = "\\\\d+",
  covs_order = NULL,
  covs_stem = NULL,
  covs_delim1 = NULL,
  covs_delim2 = NULL
)
}
\arguments{
\item{dat}{input data frame of indicators of a particular LV}

\item{x_order}{input character for order of (S)tem, (P)artner number, and (I)tem number
when creating variable names. Defaults to "spi" (Qualtrics-friendly)}

\item{x_stem}{input character stem of indicator variables for LV X}

\item{x_delim1}{optional character to separate stem from partner number (spi) or item number (sip)}

\item{x_delim2}{optional character to separate stem/partner number (spi) or stem/item number (sip) from
from final element of variable name}

\item{x_item_num}{defaults to scrape all items that match the stem with any digits that follow.
Will be updated to allow particular range of values, to make more sub-scale friendly.}

\item{distinguish_1}{input character used as the identifier for the first partner}

\item{distinguish_2}{input character used as the identifier for the first partner}

\item{y_order}{optional character for order of (S)tem, (P)artner number, and (I)tem number
when creating variable names. Defaults to "spi" (Qualtrics-friendly). This and other Y-arguments
only necessary if there is a latent Y variable to model}

\item{y_stem}{optional input character stem of indicator variables for LV X}

\item{y_delim1}{optional character to separate stem from partner number (spi) or item number (sip)}

\item{y_delim2}{optional character to separate stem/partner number (spi) or stem/item number (sip) from
from final element of variable name}

\item{y_item_num}{defaults to scrape all items that match the stem with any digits that follow.
Will be updated to allow particular range of values, to make more sub-scale friendly.}

\item{covs_order}{optional character for order of (S)tem, (P)artner number, and (I)tem number for any
covariate(s). Defaults to NULL. This and other covariate arguments only necessary if there are covariates to be scripted in your model(s).}

\item{covs_stem}{optional input character stem(s) of indicator variables for covariate(s). Can accept a single stem (e.g., "anx"), or a vector of stems (e.g., c("anx", "dep")).
Defaults to NULL.}

\item{covs_delim1}{optional character to separate stem from partner number (spi) or item number (sip) for covariate(s). Defaults to NULL.}

\item{covs_delim2}{optional character to separate stem/partner number (spi) or stem/item number (sip) from}
}
\value{
a list, referred in short-hand as a "dvn" (dyad variable names list) containing variable names for p1, p2, # of items per LV,
characters distinguishing partners, and total number of indicators
}
\description{
This function scrapes the names of indicator variables in a
wide-format data set used for dyadic analyses of two latent variables (LV; X and Y),
and indexes which indicators correspond to which partner, for which LV.
It is used primarily to guide the syntax-writing of the other dySEM functions.
}
\examples{
dvnx <- scrapeVarCross(dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
x_delim2="_", distinguish_1="1", distinguish_2="2")
dvnxy <- scrapeVarCross(dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
x_delim2="_", distinguish_1="1", distinguish_2="2",
y_order="spi", y_stem="com", y_delim1 = ".", y_delim2="_")
}
\concept{variable-scraping functions}
