% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{sql}
\alias{sql}
\title{Execute SQL query against a dataset.}
\usage{
sql(dataset, query, query_params = list())
}
\arguments{
\item{dataset}{Dataset URL or path.}

\item{query}{SQL query.}

\item{query_params}{List of positional query parameters.}
}
\value{
Data frame with data from query results.
}
\description{
Execute SQL query against a dataset.
}
\examples{
\dontrun{
  dwapi::sql(dataset="user/dataset",
    query="SELECT *
           FROM TableName
           LIMIT 10")

  dwapi::sql(dataset="user/dataset",
    query="SELECT *
           FROM TableName where `field1` = ? AND `field2` > ?
           LIMIT 10",
    queryParameters = list("value", 5.0))
}
}
